/*
 * Decompiled with CFR 0.152.
 */
package kala.control;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import kala.collection.base.Iterators;
import kala.collection.base.Mappable;
import kala.collection.base.Traversable;
import kala.control.Option;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OptionContainer<T>
extends Iterable<T>,
Mappable<T>,
Traversable<T> {
    public boolean isDefined();

    @Override
    default public boolean isEmpty() {
        return !this.isDefined();
    }

    @Override
    @NotNull
    default public Stream<T> stream() {
        return this.isDefined() ? Stream.of(this.get()) : Stream.empty();
    }

    @Override
    @NotNull
    default public Stream<T> parallelStream() {
        return (Stream)this.stream().parallel();
    }

    @Override
    @NotNull
    default public Iterator<T> iterator() {
        return this.isDefined() ? Iterators.of(this.get()) : Iterators.empty();
    }

    @Override
    default public int size() {
        return this.isDefined() ? 1 : 0;
    }

    public T get();

    @Nullable
    default public T getOrNull() {
        return this.isDefined() ? (T)this.get() : null;
    }

    @NotNull
    default public Option<T> getOption() {
        return this.isDefined() ? Option.some(this.get()) : Option.none();
    }

    default public T getOrDefault(T defaultValue) {
        return this.isDefined() ? this.get() : defaultValue;
    }

    default public T getOrElse(@NotNull Supplier<? extends T> supplier) {
        return this.isDefined() ? this.get() : supplier.get();
    }

    default public <Ex extends Throwable> T getOrThrowException(@NotNull Ex exception) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(exception);
            throw exception;
        }
        return this.get();
    }

    default public <Ex extends Throwable> T getOrThrow(@NotNull Supplier<? extends Ex> supplier) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(supplier);
            throw (Throwable)supplier.get();
        }
        return this.get();
    }

    default public <U> U get(@NotNull Function<? super T, ? extends U> mapper) {
        return mapper.apply(this.get());
    }

    @Nullable
    default public <U> U getOrNull(@NotNull Function<? super T, ? extends U> mapper) {
        return this.isDefined() ? (U)mapper.apply((T)this.get()) : null;
    }

    @NotNull
    default public <U> Option<U> getOption(@NotNull Function<? super T, ? extends U> mapper) {
        return this.isDefined() ? Option.some(mapper.apply(this.get())) : Option.none();
    }

    default public <U> U getOrDefault(@NotNull Function<? super T, ? extends U> mapper, U defaultValue) {
        return this.isDefined() ? mapper.apply(this.get()) : defaultValue;
    }

    default public <U> U getOrElse(@NotNull Function<? super T, ? extends U> mapper, @NotNull Supplier<? extends U> supplier) {
        return this.isDefined() ? mapper.apply(this.get()) : supplier.get();
    }

    default public <U, Ex extends Throwable> U getOrThrowException(@NotNull Function<? super T, ? extends U> mapper, @NotNull Ex exception) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(exception);
            throw exception;
        }
        return mapper.apply(this.get());
    }

    default public <U, Ex extends Throwable> U getOrThrow(@NotNull Function<? super T, ? extends U> mapper, @NotNull Supplier<? extends Ex> supplier) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(supplier);
            throw (Throwable)supplier.get();
        }
        return mapper.apply(this.get());
    }

    default public void ifDefined(@NotNull Consumer<? super T> action) {
        if (this.isDefined()) {
            action.accept(this.get());
        }
    }

    default public void ifDefinedOrElse(@NotNull Consumer<? super T> action, Runnable emptyAction) {
        if (this.isDefined()) {
            action.accept(this.get());
        } else {
            emptyAction.run();
        }
    }

    @NotNull
    default public Option<T> toOption() {
        return this.getOption();
    }

    @Override
    default public <R, Builder> R collect(@NotNull Collector<? super T, Builder, ? extends R> factory) {
        Collector<T, Builder, R> f = factory;
        Builder builder = f.supplier().get();
        if (this.isDefined()) {
            f.accumulator().accept(builder, this.get());
        }
        return f.finisher().apply(builder);
    }

    @Override
    @NotNull
    public <U> OptionContainer<U> map(@NotNull Function<? super T, ? extends U> var1);

    @Override
    @Contract(pure=true)
    default public int count(@NotNull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.anyMatch(predicate) ? 1 : 0;
    }

    @Override
    default public <U> U foldLeft(U zero, @NotNull BiFunction<? super U, ? super T, ? extends U> op) {
        if (this.isEmpty()) {
            return zero;
        }
        return op.apply(zero, this.get());
    }

    @Override
    @Contract(pure=true)
    default public <U> U foldRight(U zero, @NotNull BiFunction<? super T, ? super U, ? extends U> op) {
        if (this.isEmpty()) {
            return zero;
        }
        return op.apply(this.get(), zero);
    }

    @Override
    default public T reduceLeft(@NotNull BiFunction<? super T, ? super T, ? extends T> op) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get();
    }

    @Override
    default public T reduceRight(@NotNull BiFunction<? super T, ? super T, ? extends T> op) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public Option<T> reduceLeftOption(@NotNull BiFunction<? super T, ? super T, ? extends T> op) {
        return this.getOption();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public Option<T> reduceRightOption(@NotNull BiFunction<? super T, ? super T, ? extends T> op) {
        return this.getOption();
    }

    @Override
    @Contract(pure=true)
    default public boolean anyMatch(@NotNull Predicate<? super T> predicate) {
        return this.isDefined() && predicate.test(this.get());
    }

    @Override
    @Contract(pure=true)
    default public boolean allMatch(@NotNull Predicate<? super T> predicate) {
        return this.isEmpty() || predicate.test(this.get());
    }

    @Override
    @Contract(pure=true)
    default public boolean noneMatch(@NotNull Predicate<? super T> predicate) {
        return this.isEmpty() || !predicate.test(this.get());
    }

    @Override
    default public boolean contains(Object value) {
        return this.isDefined() && Objects.equals(value, this.get());
    }

    @Override
    @NotNull
    default public Option<T> find(@NotNull Predicate<? super T> predicate) {
        return this.isDefined() && predicate.test(this.get()) ? Option.some(this.get()) : Option.none();
    }

    @Override
    default public void forEach(@NotNull Consumer<? super T> action) {
        Objects.requireNonNull(action);
        if (this.isDefined()) {
            action.accept(this.get());
        }
    }
}

