/*
 * Decompiled with CFR 0.152.
 */
package kala.control;

import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import kala.control.Either;
import kala.control.Option;
import kala.control.OptionContainer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Result<T, E>
extends OptionContainer<T>,
Serializable {
    @Contract(value="_ -> param1", pure=true)
    public static <T, E> Result<T, E> narrow(Result<? extends T, ? extends E> result) {
        return result;
    }

    @Contract(value="_ -> new")
    public static <T, E> Result<T, E> ok(T value) {
        return new Ok(value);
    }

    @Contract(value="_ -> new")
    public static <T, E> Result<T, E> err(E value) {
        return new Err(value);
    }

    default public boolean isOk() {
        return this instanceof Ok;
    }

    default public boolean isErr() {
        return this instanceof Err;
    }

    @Override
    default public boolean isDefined() {
        return this.isOk();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    default public T get() {
        Object value;
        Result result = this;
        if (!(result instanceof Ok)) throw new NoSuchElementException("Result.Err#get()");
        Ok ok = (Ok)result;
        try {
            Object t;
            value = t = ok.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public E getErr() {
        Object err2;
        Result result = this;
        if (!(result instanceof Err)) throw new NoSuchElementException("Result.Ok#getErr()");
        Err err = (Err)result;
        try {
            Object e;
            err2 = e = err.err();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return err2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    default public E getErrOrNull() {
        Object err2;
        E e;
        Result result = this;
        if (!(result instanceof Err)) {
            e = null;
            return e;
        }
        Err err = (Err)result;
        try {
            Object e2;
            err2 = e2 = err.err();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        e = err2;
        return e;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    default public Option<E> getErrOption() {
        Object err2;
        Option<Object> option;
        Result result = this;
        if (!(result instanceof Err)) {
            option = Option.none();
            return option;
        }
        Err err = (Err)result;
        try {
            Object e;
            err2 = e = err.err();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        option = Option.some(err2);
        return option;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    default public <U> Result<U, E> map(@NotNull Function<? super T, ? extends U> mapper) {
        Object value;
        Result<U, E> result;
        Result<U, E> result2 = this;
        if (!(result2 instanceof Ok)) {
            result = this;
            return result;
        }
        Ok ok = (Ok)result2;
        try {
            Object t;
            value = t = ok.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        result = Result.ok(mapper.apply(value));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    default public <U> Result<T, U> mapErr(@NotNull Function<? super E, ? extends U> mapper) {
        Object err2;
        Result<T, U> result;
        Result<T, U> result2 = this;
        if (!(result2 instanceof Err)) {
            result = this;
            return result;
        }
        Err err = (Err)result2;
        try {
            Object e;
            err2 = e = err.err();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        result = Result.err(mapper.apply(err2));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    default public <U> Result<U, E> flatMap(@NotNull Function<? super T, ? extends Result<? extends U, ? extends E>> mapper) {
        Object value;
        Result<U, E> result;
        Result<U, E> result2 = this;
        if (!(result2 instanceof Ok)) {
            result = this;
            return result;
        }
        Ok ok = (Ok)result2;
        try {
            Object t;
            value = t = ok.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        result = Result.narrow(mapper.apply(value));
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Contract(value="-> new")
    @NotNull
    default public Either<E, T> toEither() {
        Object err2;
        Record record;
        Result result = this;
        Objects.requireNonNull(result);
        Result result2 = result;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Ok.class, Err.class}, (Object)result2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object value;
                Ok ok = (Ok)result2;
                try {
                    Object t;
                    value = t = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                record = Either.right(value);
                return record;
            }
            case 1: 
        }
        Err err = (Err)result2;
        {
            Object e;
            err2 = e = err.err();
        }
        record = Either.left(err2);
        return record;
    }

    public record Ok<T, E>(T value) implements Result<T, E>
    {
        public <U> Ok<T, U> cast() {
            return this;
        }

        @Override
        public String toString() {
            return "Result.Ok[" + String.valueOf(this.get()) + "]";
        }
    }

    public record Err<T, E>(E err) implements Result<T, E>
    {
        public <U> Err<U, E> cast() {
            return this;
        }

        @Override
        public String toString() {
            return "Result.Err[" + String.valueOf(this.getErr()) + "]";
        }
    }
}

