/*
 * Decompiled with CFR 0.152.
 */
package kala.control.primitive;

import java.util.NoSuchElementException;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.control.Option;
import kala.control.primitive.PrimitiveOption;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BooleanOption
implements PrimitiveOption<Boolean>,
BooleanTraversable {
    private static final long serialVersionUID = 3226319253753655469L;
    private static final int HASH_MAGIC = 773806848;
    public static final BooleanOption True = new BooleanOption(true);
    public static final BooleanOption False = new BooleanOption(false);
    public static final BooleanOption None = new BooleanOption();
    private final boolean isDefined;
    private final boolean value;
    private final transient int hashCode;
    private final transient String name;

    private BooleanOption() {
        this.isDefined = false;
        this.value = false;
        this.name = "OptionBoolean.None";
        this.hashCode = 1937147281;
    }

    private BooleanOption(boolean value) {
        this.isDefined = true;
        this.value = value;
        this.name = value ? "OptionBoolean.True" : "OptionBoolean.False";
        this.hashCode = 773806848 + Boolean.hashCode(value);
    }

    @NotNull
    public static BooleanOption some(boolean value) {
        return value ? True : False;
    }

    @NotNull
    public static BooleanOption none() {
        return None;
    }

    @Deprecated
    @NotNull
    public static BooleanOption of(boolean value) {
        return value ? True : False;
    }

    @Deprecated
    @NotNull
    public static BooleanOption of(@Nullable Boolean value) {
        return BooleanOption.ofNullable(value);
    }

    @NotNull
    public static BooleanOption ofNullable(@Nullable Boolean value) {
        if (value == null) {
            return None;
        }
        return value != false ? True : False;
    }

    @NotNull
    public static BooleanOption fromOption(@NotNull Option<? extends Boolean> option) {
        if (option.isDefined()) {
            return BooleanOption.some(option.get());
        }
        return None;
    }

    public boolean isDefined() {
        return this.isDefined;
    }

    @Override
    public boolean isEmpty() {
        return !this.isDefined;
    }

    @Flow(sourceIsContainer=true)
    public boolean get() {
        if (this.isDefined) {
            return this.value;
        }
        throw new NoSuchElementException("OptionBoolean.None.get()");
    }

    @Nullable
    public Boolean getOrNull() {
        return this.isDefined ? Boolean.valueOf(this.value) : null;
    }

    @NotNull
    public BooleanOption getOption() {
        return this;
    }

    @Override
    @NotNull
    public BooleanIterator iterator() {
        return this.isDefined ? BooleanIterator.of(this.value) : BooleanIterator.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Option) {
            Option other = (Option)o;
            if (this.isEmpty()) {
                return other.isEmpty();
            }
            if (other.isEmpty()) {
                return false;
            }
            Object v = other.get();
            return v instanceof Boolean && this.get() == ((Boolean)v).booleanValue();
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.name;
    }

    private Object readResolve() {
        if (this.isDefined) {
            return this.value ? True : False;
        }
        return None;
    }
}

