/*
 * Decompiled with CFR 0.152.
 */
package kala.control.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.control.AnyTry;
import kala.control.Try;
import kala.control.primitive.ByteOption;
import kala.control.primitive.PrimitiveTry;
import kala.function.CheckedByteSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ByteTry
implements PrimitiveTry<Byte>,
ByteTraversable,
Serializable {
    private static final long serialVersionUID = 8279218383491584792L;
    private final byte value;
    private final Throwable cause;

    private ByteTry(byte value, Throwable cause) {
        this.value = value;
        this.cause = cause;
    }

    @NotNull
    public static ByteTry success(byte value) {
        return new ByteTry(value, null);
    }

    @NotNull
    public static ByteTry failure(@NotNull Throwable exception) {
        Objects.requireNonNull(exception);
        return new ByteTry(0, exception);
    }

    @NotNull
    public static ByteTry of(@NotNull CheckedByteSupplier<?> supplier) {
        Objects.requireNonNull(supplier);
        try {
            return ByteTry.success(supplier.getAsByteChecked());
        }
        catch (Throwable ex) {
            return ByteTry.failure(ex);
        }
    }

    @Override
    public boolean isSuccess() {
        return this.cause == null;
    }

    @Override
    public boolean isFailure() {
        return this.cause != null;
    }

    @Override
    @Deprecated
    @NotNull
    public Byte getValue() {
        return this.get();
    }

    public byte get() {
        if (this.isFailure()) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    @Override
    @Nullable
    public Byte getOrNull() {
        return this.isSuccess() ? Byte.valueOf(this.get()) : null;
    }

    public ByteOption getOption() {
        return this.isSuccess() ? ByteOption.some(this.get()) : ByteOption.none();
    }

    @Override
    @NotNull
    public Throwable getCause() {
        return this.cause;
    }

    @NotNull
    public <Ex extends Throwable> ByteTry rethrow() throws Ex {
        if (this.isFailure()) {
            throw this.cause;
        }
        return this;
    }

    @NotNull
    public <Ex extends Throwable> ByteTry rethrow(@NotNull Class<? extends Ex> type) throws Ex {
        if (type.isInstance(this.cause)) {
            throw this.cause;
        }
        return this;
    }

    @NotNull
    public ByteTry rethrowFatal() {
        if (Try.isFatal(this.cause)) {
            Try.sneakyThrow(this.cause);
        }
        return this;
    }

    @Override
    @NotNull
    public ByteIterator iterator() {
        return this.isSuccess() ? ByteIterator.of(this.get()) : ByteIterator.empty();
    }

    public int hashCode() {
        if (this.isSuccess()) {
            return Byte.hashCode(this.get()) + SUCCESS_HASH_MAGIC;
        }
        return this.getCause().hashCode() + FAILURE_HASH_MAGIC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnyTry)) {
            return false;
        }
        AnyTry other = (AnyTry)o;
        if (this.isSuccess() && other.isSuccess()) {
            if (other instanceof ByteTry) {
                return this.get() == ((ByteTry)other).get();
            }
            if (other instanceof Try) {
                Object v = other.getValue();
                return v instanceof Byte && this.get() == ((Byte)v).byteValue();
            }
            return false;
        }
        if (this.isFailure() && other.isFailure()) {
            return this.getCause().equals(other.getCause());
        }
        return false;
    }

    public String toString() {
        if (this.isSuccess()) {
            return "ByteTry.Success[" + this.get() + "]";
        }
        return "ByteTry.Failure[" + String.valueOf(this.cause) + "]";
    }
}

