/*
 * Decompiled with CFR 0.152.
 */
package kala.control.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.control.Option;
import kala.control.primitive.PrimitiveOption;
import kala.function.CharConsumer;
import kala.function.CharFunction;
import kala.function.CharPredicate;
import kala.function.CharSupplier;
import kala.function.CharUnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CharOption
implements PrimitiveOption<Character>,
CharTraversable {
    private static final long serialVersionUID = -8990024629462620023L;
    public static final CharOption None = new CharOption();
    private final char value;

    private CharOption() {
        this.value = '\u0000';
    }

    private CharOption(char value) {
        this.value = value;
    }

    @NotNull
    public static CharOption some(char value) {
        return new CharOption(value);
    }

    @NotNull
    public static CharOption none() {
        return None;
    }

    @Deprecated
    @NotNull
    public static CharOption of(char value) {
        return CharOption.some(value);
    }

    @Deprecated
    @NotNull
    public static CharOption of(@Nullable Character value) {
        return CharOption.ofNullable(value);
    }

    @NotNull
    public static CharOption ofNullable(@Nullable Character value) {
        return value == null ? None : CharOption.some(value.charValue());
    }

    public boolean isDefined() {
        return this != None;
    }

    @Override
    public boolean isEmpty() {
        return this == None;
    }

    public char get() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("CharOption.None");
        }
        return this.value;
    }

    @Nullable
    public Character getOrNull() {
        return this.isDefined() ? Character.valueOf(this.value) : null;
    }

    public char getOrDefault(char defaultValue) {
        return this.isDefined() ? this.value : defaultValue;
    }

    public char getOrElse(@NotNull CharSupplier supplier) {
        return this.isDefined() ? this.get() : supplier.getAsChar();
    }

    public <Ex extends Throwable> char getOrThrowException(@NotNull Ex exception) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(exception);
            throw exception;
        }
        return this.value;
    }

    public <Ex extends Throwable> char getOrThrow(@NotNull Supplier<? extends Ex> supplier) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(supplier);
            throw (Throwable)supplier.get();
        }
        return this.value;
    }

    @NotNull
    public CharOption orElse(CharOption other) {
        return this.isDefined() ? this : other;
    }

    @NotNull
    public CharOption map(CharUnaryOperator mapper) {
        return this.isDefined() ? CharOption.some(mapper.applyAsChar(this.value)) : None;
    }

    @NotNull
    public <T> Option<T> mapToObj(@NotNull CharFunction<? extends T> mapper) {
        return this.isDefined() ? Option.some(mapper.apply(this.value)) : Option.none();
    }

    @NotNull
    public CharOption filter(@NotNull CharPredicate predicate) {
        return this.isDefined() && predicate.test(this.value) ? this : None;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CharOption) {
            CharOption other = (CharOption)o;
            return this != None && o != None && this.value == other.value;
        }
        if (o instanceof Option) {
            Option other = (Option)o;
            if (this.isEmpty()) {
                return other.isEmpty();
            }
            if (other.isEmpty()) {
                return false;
            }
            Object v = other.get();
            return v instanceof Character && this.value == ((Character)v).charValue();
        }
        return false;
    }

    public int hashCode() {
        return this.isDefined() ? -818206074 + Character.hashCode(this.value) : 1937147281;
    }

    public String toString() {
        return this == None ? "CharOption.None" : "CharOption[" + this.value + "]";
    }

    @Override
    @NotNull
    public CharIterator iterator() {
        return this.isDefined() ? CharIterator.of(this.value) : CharIterator.empty();
    }

    @Override
    public void forEach(@NotNull CharConsumer action) {
        if (this.isDefined()) {
            action.accept(this.value);
        }
    }

    private Object writeReplace() {
        return new Data(this == None ? null : Character.valueOf(this.value));
    }

    private static final class Data
    implements Serializable {
        private static final long serialVersionUID = -2044232156734869349L;
        private final Character value;

        Data(Character value) {
            this.value = value;
        }

        Object readResolve() {
            return this.value == null ? None : CharOption.some(this.value.charValue());
        }
    }
}

