/*
 * Decompiled with CFR 0.152.
 */
package kala.control.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.control.AnyTry;
import kala.control.Try;
import kala.control.primitive.CharOption;
import kala.control.primitive.PrimitiveTry;
import kala.function.CheckedCharSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CharTry
implements PrimitiveTry<Character>,
CharTraversable,
Serializable {
    private static final long serialVersionUID = 8279218383491584792L;
    private final char value;
    private final Throwable cause;

    private CharTry(char value, Throwable cause) {
        this.value = value;
        this.cause = cause;
    }

    @NotNull
    public static CharTry success(char value) {
        return new CharTry(value, null);
    }

    @NotNull
    public static CharTry failure(@NotNull Throwable exception) {
        Objects.requireNonNull(exception);
        return new CharTry('\u0000', exception);
    }

    @NotNull
    public static CharTry of(@NotNull CheckedCharSupplier<?> supplier) {
        Objects.requireNonNull(supplier);
        try {
            return CharTry.success(supplier.getAsCharChecked());
        }
        catch (Throwable ex) {
            return CharTry.failure(ex);
        }
    }

    @Override
    public boolean isSuccess() {
        return this.cause == null;
    }

    @Override
    public boolean isFailure() {
        return this.cause != null;
    }

    @Override
    @Deprecated
    @NotNull
    public Character getValue() {
        return Character.valueOf(this.get());
    }

    public char get() {
        if (this.isFailure()) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    @Override
    @Nullable
    public Character getOrNull() {
        return this.isSuccess() ? Character.valueOf(this.get()) : null;
    }

    public CharOption getOption() {
        return this.isSuccess() ? CharOption.some(this.get()) : CharOption.none();
    }

    @Override
    @NotNull
    public Throwable getCause() {
        return this.cause;
    }

    @NotNull
    public <Ex extends Throwable> CharTry rethrow() throws Ex {
        if (this.isFailure()) {
            throw this.cause;
        }
        return this;
    }

    @NotNull
    public <Ex extends Throwable> CharTry rethrow(@NotNull Class<? extends Ex> type) throws Ex {
        if (type.isInstance(this.cause)) {
            throw this.cause;
        }
        return this;
    }

    @NotNull
    public CharTry rethrowFatal() {
        if (Try.isFatal(this.cause)) {
            Try.sneakyThrow(this.cause);
        }
        return this;
    }

    @Override
    @NotNull
    public CharIterator iterator() {
        return this.isSuccess() ? CharIterator.of(this.get()) : CharIterator.empty();
    }

    public int hashCode() {
        if (this.isSuccess()) {
            return Character.hashCode(this.get()) + SUCCESS_HASH_MAGIC;
        }
        return this.getCause().hashCode() + FAILURE_HASH_MAGIC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnyTry)) {
            return false;
        }
        AnyTry other = (AnyTry)o;
        if (this.isSuccess() && other.isSuccess()) {
            if (other instanceof CharTry) {
                return this.get() == ((CharTry)other).get();
            }
            if (other instanceof Try) {
                Object v = other.getValue();
                return v instanceof Character && this.get() == ((Character)v).charValue();
            }
            return false;
        }
        if (this.isFailure() && other.isFailure()) {
            return this.getCause().equals(other.getCause());
        }
        return false;
    }

    public String toString() {
        if (this.isSuccess()) {
            return "CharTry.Success[" + this.get() + "]";
        }
        return "CharTry.Failure[" + String.valueOf(this.cause) + "]";
    }
}

