/*
 * Decompiled with CFR 0.152.
 */
package kala.control.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.control.AnyTry;
import kala.control.Try;
import kala.control.primitive.DoubleOption;
import kala.control.primitive.PrimitiveTry;
import kala.function.CheckedDoubleSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DoubleTry
implements PrimitiveTry<Double>,
DoubleTraversable,
Serializable {
    private static final long serialVersionUID = 8279218383491584792L;
    private final double value;
    private final Throwable cause;

    private DoubleTry(double value, Throwable cause) {
        this.value = value;
        this.cause = cause;
    }

    @NotNull
    public static DoubleTry success(double value) {
        return new DoubleTry(value, null);
    }

    @NotNull
    public static DoubleTry failure(@NotNull Throwable exception) {
        Objects.requireNonNull(exception);
        return new DoubleTry(0.0, exception);
    }

    @NotNull
    public static DoubleTry of(@NotNull CheckedDoubleSupplier<?> supplier) {
        Objects.requireNonNull(supplier);
        try {
            return DoubleTry.success(supplier.getAsDoubleChecked());
        }
        catch (Throwable ex) {
            return DoubleTry.failure(ex);
        }
    }

    @Override
    public boolean isSuccess() {
        return this.cause == null;
    }

    @Override
    public boolean isFailure() {
        return this.cause != null;
    }

    @Override
    @Deprecated
    @NotNull
    public Double getValue() {
        return this.get();
    }

    public double get() {
        if (this.isFailure()) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    @Override
    @Nullable
    public Double getOrNull() {
        return this.isSuccess() ? Double.valueOf(this.get()) : null;
    }

    public DoubleOption getOption() {
        return this.isSuccess() ? DoubleOption.some(this.get()) : DoubleOption.none();
    }

    @Override
    @NotNull
    public Throwable getCause() {
        return this.cause;
    }

    @NotNull
    public <Ex extends Throwable> DoubleTry rethrow() throws Ex {
        if (this.isFailure()) {
            throw this.cause;
        }
        return this;
    }

    @NotNull
    public <Ex extends Throwable> DoubleTry rethrow(@NotNull Class<? extends Ex> type) throws Ex {
        if (type.isInstance(this.cause)) {
            throw this.cause;
        }
        return this;
    }

    @NotNull
    public DoubleTry rethrowFatal() {
        if (Try.isFatal(this.cause)) {
            Try.sneakyThrow(this.cause);
        }
        return this;
    }

    @Override
    @NotNull
    public DoubleIterator iterator() {
        return this.isSuccess() ? DoubleIterator.of(this.get()) : DoubleIterator.empty();
    }

    public int hashCode() {
        if (this.isSuccess()) {
            return Double.hashCode(this.get()) + SUCCESS_HASH_MAGIC;
        }
        return this.getCause().hashCode() + FAILURE_HASH_MAGIC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnyTry)) {
            return false;
        }
        AnyTry other = (AnyTry)o;
        if (this.isSuccess() && other.isSuccess()) {
            if (other instanceof DoubleTry) {
                return Double.doubleToLongBits(this.get()) == Double.doubleToLongBits(((DoubleTry)other).get());
            }
            if (other instanceof Try) {
                Object v = other.getValue();
                return v instanceof Double && Double.doubleToLongBits(this.get()) == Double.doubleToLongBits((Double)v);
            }
            return false;
        }
        if (this.isFailure() && other.isFailure()) {
            return this.getCause().equals(other.getCause());
        }
        return false;
    }

    public String toString() {
        if (this.isSuccess()) {
            return "DoubleTry.Success[" + this.get() + "]";
        }
        return "DoubleTry.Failure[" + String.valueOf(this.cause) + "]";
    }
}

