/*
 * Decompiled with CFR 0.152.
 */
package kala.control.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.control.AnyTry;
import kala.control.Try;
import kala.control.primitive.FloatOption;
import kala.control.primitive.PrimitiveTry;
import kala.function.CheckedFloatSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FloatTry
implements PrimitiveTry<Float>,
FloatTraversable,
Serializable {
    private static final long serialVersionUID = 8279218383491584792L;
    private final float value;
    private final Throwable cause;

    private FloatTry(float value, Throwable cause) {
        this.value = value;
        this.cause = cause;
    }

    @NotNull
    public static FloatTry success(float value) {
        return new FloatTry(value, null);
    }

    @NotNull
    public static FloatTry failure(@NotNull Throwable exception) {
        Objects.requireNonNull(exception);
        return new FloatTry(0.0f, exception);
    }

    @NotNull
    public static FloatTry of(@NotNull CheckedFloatSupplier<?> supplier) {
        Objects.requireNonNull(supplier);
        try {
            return FloatTry.success(supplier.getAsFloatChecked());
        }
        catch (Throwable ex) {
            return FloatTry.failure(ex);
        }
    }

    @Override
    public boolean isSuccess() {
        return this.cause == null;
    }

    @Override
    public boolean isFailure() {
        return this.cause != null;
    }

    @Override
    @Deprecated
    @NotNull
    public Float getValue() {
        return Float.valueOf(this.get());
    }

    public float get() {
        if (this.isFailure()) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    @Override
    @Nullable
    public Float getOrNull() {
        return this.isSuccess() ? Float.valueOf(this.get()) : null;
    }

    public FloatOption getOption() {
        return this.isSuccess() ? FloatOption.some(this.get()) : FloatOption.none();
    }

    @Override
    @NotNull
    public Throwable getCause() {
        return this.cause;
    }

    @NotNull
    public <Ex extends Throwable> FloatTry rethrow() throws Ex {
        if (this.isFailure()) {
            throw this.cause;
        }
        return this;
    }

    @NotNull
    public <Ex extends Throwable> FloatTry rethrow(@NotNull Class<? extends Ex> type) throws Ex {
        if (type.isInstance(this.cause)) {
            throw this.cause;
        }
        return this;
    }

    @NotNull
    public FloatTry rethrowFatal() {
        if (Try.isFatal(this.cause)) {
            Try.sneakyThrow(this.cause);
        }
        return this;
    }

    @Override
    @NotNull
    public FloatIterator iterator() {
        return this.isSuccess() ? FloatIterator.of(this.get()) : FloatIterator.empty();
    }

    public int hashCode() {
        if (this.isSuccess()) {
            return Float.hashCode(this.get()) + SUCCESS_HASH_MAGIC;
        }
        return this.getCause().hashCode() + FAILURE_HASH_MAGIC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnyTry)) {
            return false;
        }
        AnyTry other = (AnyTry)o;
        if (this.isSuccess() && other.isSuccess()) {
            if (other instanceof FloatTry) {
                return Float.floatToIntBits(this.get()) == Float.floatToIntBits(((FloatTry)other).get());
            }
            if (other instanceof Try) {
                Object v = other.getValue();
                return v instanceof Float && Float.floatToIntBits(this.get()) == Float.floatToIntBits(((Float)v).floatValue());
            }
            return false;
        }
        if (this.isFailure() && other.isFailure()) {
            return this.getCause().equals(other.getCause());
        }
        return false;
    }

    public String toString() {
        if (this.isSuccess()) {
            return "FloatTry.Success[" + this.get() + "]";
        }
        return "FloatTry.Failure[" + String.valueOf(this.cause) + "]";
    }
}

