/*
 * Decompiled with CFR 0.152.
 */
package kala.control.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.control.AnyTry;
import kala.control.Try;
import kala.control.primitive.IntOption;
import kala.control.primitive.PrimitiveTry;
import kala.function.CheckedIntSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntTry
implements PrimitiveTry<Integer>,
IntTraversable,
Serializable {
    private static final long serialVersionUID = 8279218383491584792L;
    private final int value;
    private final Throwable cause;

    private IntTry(int value, Throwable cause) {
        this.value = value;
        this.cause = cause;
    }

    @NotNull
    public static IntTry success(int value) {
        return new IntTry(value, null);
    }

    @NotNull
    public static IntTry failure(@NotNull Throwable exception) {
        Objects.requireNonNull(exception);
        return new IntTry(0, exception);
    }

    @NotNull
    public static IntTry of(@NotNull CheckedIntSupplier<?> supplier) {
        Objects.requireNonNull(supplier);
        try {
            return IntTry.success(supplier.getAsIntChecked());
        }
        catch (Throwable ex) {
            return IntTry.failure(ex);
        }
    }

    @Override
    public boolean isSuccess() {
        return this.cause == null;
    }

    @Override
    public boolean isFailure() {
        return this.cause != null;
    }

    @Override
    @Deprecated
    @NotNull
    public Integer getValue() {
        return this.get();
    }

    public int get() {
        if (this.isFailure()) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    @Override
    @Nullable
    public Integer getOrNull() {
        return this.isSuccess() ? Integer.valueOf(this.get()) : null;
    }

    public IntOption getOption() {
        return this.isSuccess() ? IntOption.some(this.get()) : IntOption.none();
    }

    @Override
    @NotNull
    public Throwable getCause() {
        return this.cause;
    }

    @NotNull
    public <Ex extends Throwable> IntTry rethrow() throws Ex {
        if (this.isFailure()) {
            throw this.cause;
        }
        return this;
    }

    @NotNull
    public <Ex extends Throwable> IntTry rethrow(@NotNull Class<? extends Ex> type) throws Ex {
        if (type.isInstance(this.cause)) {
            throw this.cause;
        }
        return this;
    }

    @NotNull
    public IntTry rethrowFatal() {
        if (Try.isFatal(this.cause)) {
            Try.sneakyThrow(this.cause);
        }
        return this;
    }

    @Override
    @NotNull
    public IntIterator iterator() {
        return this.isSuccess() ? IntIterator.of(this.get()) : IntIterator.empty();
    }

    public int hashCode() {
        if (this.isSuccess()) {
            return Integer.hashCode(this.get()) + SUCCESS_HASH_MAGIC;
        }
        return this.getCause().hashCode() + FAILURE_HASH_MAGIC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnyTry)) {
            return false;
        }
        AnyTry other = (AnyTry)o;
        if (this.isSuccess() && other.isSuccess()) {
            if (other instanceof IntTry) {
                return this.get() == ((IntTry)other).get();
            }
            if (other instanceof Try) {
                Object v = other.getValue();
                return v instanceof Integer && this.get() == ((Integer)v).intValue();
            }
            return false;
        }
        if (this.isFailure() && other.isFailure()) {
            return this.getCause().equals(other.getCause());
        }
        return false;
    }

    public String toString() {
        if (this.isSuccess()) {
            return "IntTry.Success[" + this.get() + "]";
        }
        return "IntTry.Failure[" + String.valueOf(this.cause) + "]";
    }
}

