/*
 * Decompiled with CFR 0.152.
 */
package kala.control.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.control.AnyTry;
import kala.control.Try;
import kala.control.primitive.LongOption;
import kala.control.primitive.PrimitiveTry;
import kala.function.CheckedLongSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LongTry
implements PrimitiveTry<Long>,
LongTraversable,
Serializable {
    private static final long serialVersionUID = 8279218383491584792L;
    private final long value;
    private final Throwable cause;

    private LongTry(long value, Throwable cause) {
        this.value = value;
        this.cause = cause;
    }

    @NotNull
    public static LongTry success(long value) {
        return new LongTry(value, null);
    }

    @NotNull
    public static LongTry failure(@NotNull Throwable exception) {
        Objects.requireNonNull(exception);
        return new LongTry(0L, exception);
    }

    @NotNull
    public static LongTry of(@NotNull CheckedLongSupplier<?> supplier) {
        Objects.requireNonNull(supplier);
        try {
            return LongTry.success(supplier.getAsLongChecked());
        }
        catch (Throwable ex) {
            return LongTry.failure(ex);
        }
    }

    @Override
    public boolean isSuccess() {
        return this.cause == null;
    }

    @Override
    public boolean isFailure() {
        return this.cause != null;
    }

    @Override
    @Deprecated
    @NotNull
    public Long getValue() {
        return this.get();
    }

    public long get() {
        if (this.isFailure()) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    @Override
    @Nullable
    public Long getOrNull() {
        return this.isSuccess() ? Long.valueOf(this.get()) : null;
    }

    public LongOption getOption() {
        return this.isSuccess() ? LongOption.some(this.get()) : LongOption.none();
    }

    @Override
    @NotNull
    public Throwable getCause() {
        return this.cause;
    }

    @NotNull
    public <Ex extends Throwable> LongTry rethrow() throws Ex {
        if (this.isFailure()) {
            throw this.cause;
        }
        return this;
    }

    @NotNull
    public <Ex extends Throwable> LongTry rethrow(@NotNull Class<? extends Ex> type) throws Ex {
        if (type.isInstance(this.cause)) {
            throw this.cause;
        }
        return this;
    }

    @NotNull
    public LongTry rethrowFatal() {
        if (Try.isFatal(this.cause)) {
            Try.sneakyThrow(this.cause);
        }
        return this;
    }

    @Override
    @NotNull
    public LongIterator iterator() {
        return this.isSuccess() ? LongIterator.of(this.get()) : LongIterator.empty();
    }

    public int hashCode() {
        if (this.isSuccess()) {
            return Long.hashCode(this.get()) + SUCCESS_HASH_MAGIC;
        }
        return this.getCause().hashCode() + FAILURE_HASH_MAGIC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnyTry)) {
            return false;
        }
        AnyTry other = (AnyTry)o;
        if (this.isSuccess() && other.isSuccess()) {
            if (other instanceof LongTry) {
                return this.get() == ((LongTry)other).get();
            }
            if (other instanceof Try) {
                Object v = other.getValue();
                return v instanceof Long && this.get() == ((Long)v).longValue();
            }
            return false;
        }
        if (this.isFailure() && other.isFailure()) {
            return this.getCause().equals(other.getCause());
        }
        return false;
    }

    public String toString() {
        if (this.isSuccess()) {
            return "LongTry.Success[" + this.get() + "]";
        }
        return "LongTry.Failure[" + String.valueOf(this.cause) + "]";
    }
}

