/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import java.io.Serializable;
import kala.function.Hasher;
import org.jetbrains.annotations.ApiStatus;

@FunctionalInterface
public interface ByteHasher
extends Hasher<Byte> {
    @ApiStatus.Internal
    public static final ByteHasher DEFAULT = new Default();

    public static ByteHasher defaultHasher() {
        return DEFAULT;
    }

    @Override
    public int hash(byte var1);

    @Override
    default public boolean equals(byte a, byte b) {
        return a == b;
    }

    @Override
    @Deprecated
    default public int hash(Byte value) {
        return this.hash((byte)value);
    }

    @Override
    @Deprecated
    default public boolean equals(Byte a, Byte b) {
        return this.equals((byte)a, (byte)b);
    }

    @ApiStatus.Internal
    public static final class Default
    implements ByteHasher,
    Serializable {
        private static final long serialVersionUID = 0L;

        @Override
        public int hash(byte value) {
            return Byte.hashCode(value);
        }

        private Object readResolve() {
            return DEFAULT;
        }

        public String toString() {
            return "ByteHasher.Default";
        }
    }
}

