/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Consumers {
    private Consumers() {
    }

    @Contract(value="_ -> param1", pure=true)
    public static <T> Consumer<T> of(Consumer<? super T> supplier) {
        return supplier;
    }

    @NotNull
    public static <T> Consumer<T> noop() {
        return Noop.INSTANCE;
    }

    @NotNull
    public static <T, U> Consumer<Tuple2<T, U>> tupled(@NotNull BiConsumer<? super T, ? super U> biConsumer) {
        Objects.requireNonNull(biConsumer);
        return tuple -> biConsumer.accept((Object)tuple.component1(), (Object)tuple.component2());
    }

    @NotNull
    public static <T, U> BiConsumer<T, U> untupled(@NotNull Consumer<? super Tuple2<? extends T, ? extends U>> consumer) {
        Objects.requireNonNull(consumer);
        return (t, u) -> consumer.accept(Tuple.of(t, u));
    }

    private static enum Noop implements Consumer<Object>
    {
        INSTANCE;


        @Override
        public void accept(Object o) {
        }

        @Override
        @NotNull
        public Consumer<Object> andThen(@NotNull Consumer<? super Object> after) {
            return after;
        }

        public final String toString() {
            return "Consumers.Noop";
        }
    }
}

