/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import java.util.Objects;

@FunctionalInterface
public interface FloatPredicate {
    public boolean test(float var1);

    default public FloatPredicate and(FloatPredicate other) {
        Objects.requireNonNull(other);
        return value -> this.test(value) && other.test(value);
    }

    default public FloatPredicate negate() {
        return value -> !this.test(value);
    }

    default public FloatPredicate or(FloatPredicate other) {
        Objects.requireNonNull(other);
        return value -> this.test(value) || other.test(value);
    }

    public static FloatPredicate isEqual(float target) {
        return value -> Float.floatToIntBits(value) == Float.floatToIntBits(target);
    }

    public static FloatPredicate not(FloatPredicate target) {
        Objects.requireNonNull(target);
        return target.negate();
    }
}

