/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import kala.function.Memoized;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Functions {
    private Functions() {
    }

    @Contract(value="_ -> param1", pure=true)
    public static <T, R> Function<T, R> of(Function<? super T, ? extends R> function) {
        return function;
    }

    @NotNull
    public static <T> Function<T, T> identity() {
        return Identity.INSTANCE;
    }

    @NotNull
    public static <T, R> Function<T, R> memoized(@NotNull Function<? super T, ? extends R> function) {
        if (function instanceof Memoized) {
            return Functions.of(function);
        }
        return Functions.memoized(function, false);
    }

    @NotNull
    public static <T, R> Function<T, R> memoized(@NotNull Function<? super T, ? extends R> function, boolean sync) {
        Objects.requireNonNull(function);
        return new MemoizedFunction<T, R>(function, sync ? new ConcurrentHashMap() : new HashMap(), sync);
    }

    @NotNull
    public static <T, R> Function<T, R> weakMemoized(@NotNull Function<? super T, ? extends R> function) {
        return Functions.weakMemoized(function, false);
    }

    @NotNull
    public static <T, R> Function<T, R> weakMemoized(@NotNull Function<? super T, ? extends R> function, boolean sync) {
        Objects.requireNonNull(function);
        return new MemoizedFunction<T, R>(function, sync ? Collections.synchronizedMap(new WeakHashMap()) : new WeakHashMap(), sync);
    }

    @NotNull
    public static <T, U, R> Function<Tuple2<T, U>, R> tupled(@NotNull BiFunction<? super T, ? super U, ? extends R> biFunction) {
        Objects.requireNonNull(biFunction);
        return tuple -> biFunction.apply((Object)tuple.component1(), (Object)tuple.component2());
    }

    @NotNull
    public static <T, U, R> BiFunction<T, U, R> untupled(@NotNull Function<? super Tuple2<? extends T, ? extends U>, ? extends R> function) {
        Objects.requireNonNull(function);
        return (t, u) -> function.apply(Tuple.of(t, u));
    }

    @NotNull
    public static <T, U, R> Function<T, Function<U, R>> curried(@NotNull BiFunction<? super T, ? super U, ? extends R> biFunction) {
        Objects.requireNonNull(biFunction);
        return t -> u -> biFunction.apply(t, u);
    }

    @NotNull
    public static <T, U, R> BiFunction<T, U, R> uncurried(@NotNull Function<? super T, ? extends Function<? super U, ? extends R>> function) {
        Objects.requireNonNull(function);
        return (t, u) -> ((Function)function.apply(t)).apply(u);
    }

    private static enum Identity implements Function<Object, Object>
    {
        INSTANCE;


        @Override
        public Object apply(Object o) {
            return o;
        }

        @Override
        @NotNull
        public <V> Function<V, Object> compose(@NotNull Function<? super V, ?> before) {
            return before;
        }

        @Override
        @NotNull
        public <V> Function<Object, V> andThen(@NotNull Function<? super Object, ? extends V> after) {
            return after;
        }

        public String toString() {
            return "Functions.Identity";
        }
    }

    private static final class MemoizedFunction<T, R>
    implements Function<T, R>,
    Memoized,
    Serializable {
        private static final long serialVersionUID = -904511663627169337L;
        @NotNull
        final Function<? super T, ? extends R> function;
        @NotNull
        final Map<T, Object> cache;
        final boolean sync;

        MemoizedFunction(@NotNull Function<? super T, ? extends R> function, @NotNull Map<T, Object> cache, boolean sync) {
            this.function = function;
            this.cache = cache;
            this.sync = sync;
        }

        @Override
        public R apply(T t) {
            Object res = this.cache.computeIfAbsent(t, key -> {
                R v = this.function.apply(key);
                return v != null ? v : NullHole.INSTANCE;
            });
            return (R)(res != NullHole.INSTANCE ? res : null);
        }

        public String toString() {
            return "MemoizedFunction[function=" + String.valueOf(this.function) + ", cache=" + String.valueOf(this.cache) + "]";
        }
    }

    private static enum NullHole {
        INSTANCE;


        public String toString() {
            return "null";
        }
    }
}

