/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import java.util.Objects;
import java.util.function.BiPredicate;
import kala.function.Hashers;

@FunctionalInterface
public interface Hasher<T>
extends BiPredicate<T, T> {
    public static <T> Hasher<T> narrow(Hasher<? super T> hasher) {
        return hasher;
    }

    public static <T> Hasher<T> defaultHasher() {
        return Hashers.DEFAULT;
    }

    public static <T> Hasher<T> optimizedHasher() {
        return Hashers.OPTIMIZED;
    }

    public static <T> Hasher<T> identityHasher() {
        return Hashers.IDENTITY;
    }

    public int hash(T var1);

    default public boolean equals(T t1, T t2) {
        return Objects.equals(t1, t2);
    }

    @Override
    @Deprecated
    default public boolean test(T t1, T t2) {
        return this.equals(t1, t2);
    }
}

