/*
 * Decompiled with CFR 0.152.
 */
package kala.internal;

import java.util.Arrays;
import kala.collection.base.primitive.IntArrays;
import kala.collection.base.primitive.IntIterator;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class InternalIntArrayBuilder {
    private static final int DEFAULT_CAPACITY = 16;
    private int[] elements = IntArrays.EMPTY;
    private int size = 0;

    private void grow() {
        int[] newArray;
        int oldCapacity = this.elements.length;
        if (oldCapacity == 0) {
            newArray = new int[Math.max(16, this.size + 1)];
        } else {
            int newCapacity = Math.max(Math.max(oldCapacity, this.size + 1), oldCapacity + (oldCapacity >> 1));
            newArray = new int[newCapacity];
        }
        if (this.elements.length != 0) {
            System.arraycopy(this.elements, 0, newArray, 0, this.size);
        }
        this.elements = newArray;
    }

    public int size() {
        return this.size;
    }

    public int get(int idx) {
        return this.elements[idx];
    }

    public void set(int idx, int newValue) {
        this.elements[idx] = newValue;
    }

    public void append(int value) {
        if (this.size == this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = value;
    }

    public int[] toArray() {
        return this.elements.length == this.size ? this.elements : Arrays.copyOf(this.elements, this.size);
    }

    public IntIterator iterator() {
        return IntArrays.iterator(this.elements, 0, this.size);
    }
}

