/*
 * Decompiled with CFR 0.152.
 */
package kala.range.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.primitive.AbstractByteIterator;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.function.ByteConsumer;
import kala.range.BoundType;
import kala.range.RangeType;
import kala.range.primitive.IntegralRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class ByteRange
extends IntegralRange<Byte>
implements ByteTraversable,
Serializable {
    private static final long serialVersionUID = 6302220508513752097L;
    private static final int HASH_MAGIC = -481536327;
    public static final int DEFAULT_STEP = 1;
    public static final int MAX_STEP = 255;
    public static final int MAX_REVERSE_STEP = -255;
    private static final ByteRange ALL = new ByteRange(RangeType.CLOSED, -128, 127);
    private static final ByteRange EMPTY = new ByteRange(RangeType.EMPTY, 0, 0);
    @NotNull
    private final RangeType type;
    private final byte lowerBound;
    private final byte upperBound;

    private ByteRange(@NotNull RangeType type, byte lowerBound, byte upperBound) {
        this.type = type;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @NotNull
    public static ByteRange all() {
        return ALL;
    }

    @NotNull
    public static ByteRange empty() {
        return EMPTY;
    }

    @NotNull
    public static ByteRange is(byte value) {
        return new ByteRange(RangeType.CLOSED, value, value);
    }

    @NotNull
    public static ByteRange open(byte lowerBound, byte upperBound) {
        if (lowerBound >= upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than upperBound");
        }
        return new ByteRange(RangeType.OPEN, lowerBound, upperBound);
    }

    @NotNull
    public static ByteRange closed(byte lowerBound, byte upperBound) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new ByteRange(RangeType.CLOSED, lowerBound, upperBound);
    }

    @NotNull
    public static ByteRange openClosed(byte lowerBound, byte upperBound) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new ByteRange(RangeType.OPEN_CLOSED, lowerBound, upperBound);
    }

    @NotNull
    public static ByteRange closedOpen(byte lowerBound, byte upperBound) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new ByteRange(RangeType.CLOSED_OPEN, lowerBound, upperBound);
    }

    @NotNull
    public static ByteRange greaterThan(byte lowerBound) {
        return new ByteRange(RangeType.OPEN_CLOSED, lowerBound, 127);
    }

    @NotNull
    public static ByteRange atLeast(byte lowerBound) {
        return new ByteRange(RangeType.CLOSED, lowerBound, 127);
    }

    @NotNull
    public static ByteRange lessThan(byte upperBound) {
        return new ByteRange(RangeType.CLOSED_OPEN, -128, upperBound);
    }

    @NotNull
    public static ByteRange atMost(byte upperBound) {
        return new ByteRange(RangeType.CLOSED, -128, upperBound);
    }

    @Override
    @NotNull
    public RangeType getType() {
        return this.type;
    }

    public byte getLowerBound() {
        if (!this.hasLowerBound()) {
            throw new UnsupportedOperationException();
        }
        return this.lowerBound;
    }

    public byte getUpperBound() {
        if (!this.hasUpperBound()) {
            throw new UnsupportedOperationException();
        }
        return this.upperBound;
    }

    private byte strictLowerBound() {
        return this.type.getLowerBoundType() == BoundType.OPEN ? (byte)(this.lowerBound + 1) : this.lowerBound;
    }

    private byte strictUpperBound() {
        return this.type.getUpperBoundType() == BoundType.OPEN ? (byte)(this.upperBound - 1) : this.upperBound;
    }

    public byte fit(byte value) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("Range is empty");
        }
        byte strictLowerBound = this.strictLowerBound();
        byte strictUpperBound = this.strictUpperBound();
        if (strictLowerBound >= value) {
            return strictLowerBound;
        }
        if (strictUpperBound <= value) {
            return strictUpperBound;
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        return this.type == RangeType.EMPTY || this.lowerBound == this.upperBound && this.type.getLowerBoundType() != this.type.getUpperBoundType();
    }

    @Override
    public boolean contains(byte value) {
        if (this == ALL) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        return value >= this.strictLowerBound() && value <= this.strictUpperBound();
    }

    @Override
    @NotNull
    public ByteIterator iterator() {
        byte strictUpperBound;
        if (this.isEmpty()) {
            return ByteIterator.empty();
        }
        byte strictLowerBound = this.strictLowerBound();
        if (strictLowerBound == (strictUpperBound = this.strictUpperBound())) {
            return ByteIterator.of(strictLowerBound);
        }
        return new PositiveItr(strictUpperBound, 1, strictLowerBound);
    }

    @Override
    public void forEach(@NotNull ByteConsumer action) {
        this.forEachByStep(1, action);
    }

    void forEachByStep(int step, @NotNull ByteConsumer action) {
        Objects.requireNonNull(action);
        if (step == 0) {
            throw new IllegalArgumentException("step mush not be zero");
        }
        if (step > 255 || step < -255) {
            throw new IllegalArgumentException("step too large");
        }
        if (this.isEmpty()) {
            return;
        }
        byte strictLowerBound = this.strictLowerBound();
        byte strictUpperBound = this.strictUpperBound();
        if (step > 0) {
            byte value = strictLowerBound;
            while (value <= strictUpperBound) {
                action.accept(value);
                if (127 - step >= value) {
                    value = (byte)(value + step);
                    continue;
                }
                break;
            }
        } else {
            byte value = strictUpperBound;
            while (value >= strictLowerBound) {
                action.accept(value);
                if (-128 - step <= value) {
                    value = (byte)(value + step);
                    continue;
                }
                break;
            }
        }
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + Byte.hashCode(this.lowerBound);
        result = result * 31 + Byte.hashCode(this.upperBound);
        return result + -481536327;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteRange)) {
            return false;
        }
        ByteRange ByteRange2 = (ByteRange)o;
        return this.lowerBound == ByteRange2.lowerBound && this.upperBound == ByteRange2.upperBound && this.type == ByteRange2.type;
    }

    private static String prettyToString(byte value) {
        if (value == 127) {
            return "Byte.MAX_VALUE";
        }
        if (value == -128) {
            return "Byte.MIN_VALUE";
        }
        return String.valueOf(value);
    }

    public String toString() {
        if (this == EMPTY) {
            return "ByteRange.Empty";
        }
        if (this == ALL) {
            return "ByteRange.All";
        }
        BoundType lowerBoundType = this.type.getLowerBoundType();
        BoundType upperBoundType = this.type.getUpperBoundType();
        StringBuilder res = new StringBuilder(32);
        res.append("ByteRange");
        switch (lowerBoundType) {
            case OPEN: {
                res.append('(');
                break;
            }
            case CLOSED: {
                res.append('[');
                break;
            }
            case INFINITY: {
                throw new AssertionError();
            }
        }
        res.append(ByteRange.prettyToString(this.lowerBound)).append("..").append(ByteRange.prettyToString(this.upperBound));
        switch (upperBoundType) {
            case OPEN: {
                res.append(')');
                break;
            }
            case CLOSED: {
                res.append(']');
                break;
            }
            case INFINITY: {
                throw new AssertionError();
            }
        }
        return res.toString();
    }

    private static final class PositiveItr
    extends AbstractByteIterator {
        private byte upperBound;
        private final @Range(from=1L, to=255L) int step;
        private byte value;

        PositiveItr(byte upperBound, int step, byte initialValue) {
            this.upperBound = upperBound;
            this.step = step;
            this.value = initialValue;
        }

        @Override
        public boolean hasNext() {
            return this.value <= this.upperBound;
        }

        @Override
        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte res = this.value;
            if (127 - this.step < this.value) {
                this.upperBound = (byte)-128;
                this.value = (byte)127;
            } else {
                this.value = (byte)(this.value + this.step);
            }
            return res;
        }
    }

    private static final class ReverseItr
    extends AbstractByteIterator {
        private byte lowerBound;
        private final @Range(from=-255L, to=-1L) int step;
        private byte value;

        private ReverseItr(byte lowerBound, @Range(from=-128L, to=-1L) int step, byte initialValue) {
            this.lowerBound = lowerBound;
            this.step = step;
            this.value = initialValue;
        }

        @Override
        public boolean hasNext() {
            return this.value >= this.lowerBound;
        }

        @Override
        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte res = this.value;
            if (-128 - this.step > this.value) {
                this.lowerBound = (byte)127;
                this.value = (byte)-128;
            } else {
                this.value = (byte)(this.value + this.step);
            }
            return res;
        }
    }
}

