/*
 * Decompiled with CFR 0.152.
 */
package kala.reflect;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class TypeLiteral<T>
implements Serializable {
    private static final long serialVersionUID = 6116839399568406117L;
    private static final int HASH_MAGIC = 705347658;
    @NotNull
    private final Type type;

    public static <T> TypeLiteral<T> of(@NotNull Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return new TypeLiteral<T>(clazz);
    }

    public static TypeLiteral<?> of(@NotNull Type type) {
        Objects.requireNonNull(type);
        return new TypeLiteral(type);
    }

    private TypeLiteral(@NotNull Type type) {
        this.type = type;
    }

    protected TypeLiteral() {
        this.type = this.capture();
    }

    @NotNull
    private Type capture() {
        ParameterizedType superType;
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType && (superType = (ParameterizedType)genericSuperclass).getRawType() == TypeLiteral.class) {
            return superType.getActualTypeArguments()[0];
        }
        throw new IllegalStateException();
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeLiteral)) {
            return false;
        }
        return this.type.equals(((TypeLiteral)o).type);
    }

    public final int hashCode() {
        return this.type.hashCode() + 705347658;
    }

    public final String toString() {
        return "TypeLiteral[" + String.valueOf(this.type) + "]";
    }
}

