/*
 * Decompiled with CFR 0.152.
 */
package kala.text;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.util.Formatter;
import java.util.Locale;
import java.util.Objects;
import kala.text.StringSlice;
import org.jetbrains.annotations.NotNull;

public class StringAppender
extends Writer
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private final StringBuilder builder;

    public StringAppender() {
        this.builder = new StringBuilder();
    }

    public StringAppender(int capacity) {
        this.builder = new StringBuilder(capacity);
    }

    public StringAppender(@NotNull String value) {
        this.builder = new StringBuilder(value);
    }

    public StringAppender(@NotNull CharSequence value) {
        this.builder = new StringBuilder(value);
    }

    public StringAppender(@NotNull StringBuilder builder) {
        this.builder = Objects.requireNonNull(builder);
    }

    @NotNull
    public StringBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public void write(int c) {
        this.builder.append((char)c);
    }

    @Override
    public void write(@NotNull String str) {
        this.builder.append(str);
    }

    @Override
    public void write(@NotNull String str, int off, int len) {
        this.builder.append(str, off, off + len);
    }

    @Override
    public void write(char @NotNull [] str, int offset, int len) {
        this.builder.append(str, offset, len);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
    }

    public void appendTo(Appendable appendable) throws IOException {
        appendable.append(this.builder);
    }

    public StringAppender append(char[] str) {
        this.builder.append(str);
        return this;
    }

    public StringAppender append(char[] str, int offset, int len) {
        this.builder.append(str, offset, len);
        return this;
    }

    public StringAppender append(boolean b) {
        this.builder.append(b);
        return this;
    }

    @Override
    public StringAppender append(char c) {
        this.builder.append(c);
        return this;
    }

    public StringAppender append(int i) {
        this.builder.append(i);
        return this;
    }

    public StringAppender append(long lng) {
        this.builder.append(lng);
        return this;
    }

    public StringAppender append(float f) {
        this.builder.append(f);
        return this;
    }

    public StringAppender append(double d) {
        this.builder.append(d);
        return this;
    }

    public StringAppender append(Object obj) {
        if (obj == null) {
            this.builder.append((String)null);
        } else if (obj.getClass().isArray()) {
            Object object = obj;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Object[].class, char[].class, boolean[].class, byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class}, (Object)object2, n)) {
                case 0: {
                    Object[] objects = (Object[])object2;
                    this.appendArray(objects);
                    break;
                }
                case 1: {
                    char[] chars = (char[])object2;
                    this.appendArray(chars);
                    break;
                }
                case 2: {
                    boolean[] booleans = (boolean[])object2;
                    this.appendArray(booleans);
                    break;
                }
                case 3: {
                    byte[] bytes = (byte[])object2;
                    this.appendArray(bytes);
                    break;
                }
                case 4: {
                    short[] shorts = (short[])object2;
                    this.appendArray(shorts);
                    break;
                }
                case 5: {
                    int[] ints = (int[])object2;
                    this.appendArray(ints);
                    break;
                }
                case 6: {
                    long[] longs = (long[])object2;
                    this.appendArray(longs);
                    break;
                }
                case 7: {
                    float[] floats = (float[])object2;
                    this.appendArray(floats);
                    break;
                }
                case 8: {
                    double[] doubles = (double[])object2;
                    this.appendArray(doubles);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown array type: " + String.valueOf(obj.getClass())));
                }
            }
        } else {
            this.builder.append(obj);
        }
        return this;
    }

    public StringAppender appendNull() {
        this.builder.append((String)null);
        return this;
    }

    public StringAppender appendArray(Object[] array) {
        if (array == null) {
            this.appendNull();
            return this;
        }
        if (array.length == 0) {
            this.builder.append("[]");
            return this;
        }
        this.builder.append('[');
        this.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            this.builder.append(", ");
            this.append(array[i]);
        }
        this.builder.append(']');
        return this;
    }

    public StringAppender appendArray(char[] array) {
        if (array == null) {
            this.appendNull();
            return this;
        }
        if (array.length == 0) {
            this.builder.append("[]");
            return this;
        }
        this.builder.append('[');
        this.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            this.builder.append(", ");
            this.append(array[i]);
        }
        this.builder.append(']');
        return this;
    }

    public StringAppender appendArray(boolean[] array) {
        if (array == null) {
            this.appendNull();
            return this;
        }
        if (array.length == 0) {
            this.builder.append("[]");
            return this;
        }
        this.builder.append('[');
        this.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            this.builder.append(", ");
            this.append(array[i]);
        }
        this.builder.append(']');
        return this;
    }

    public StringAppender appendArray(byte[] array) {
        if (array == null) {
            this.appendNull();
            return this;
        }
        if (array.length == 0) {
            this.builder.append("[]");
            return this;
        }
        this.builder.append('[');
        this.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            this.builder.append(", ");
            this.append(array[i]);
        }
        this.builder.append(']');
        return this;
    }

    public StringAppender appendArray(short[] array) {
        if (array == null) {
            this.appendNull();
            return this;
        }
        if (array.length == 0) {
            this.builder.append("[]");
            return this;
        }
        this.builder.append('[');
        this.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            this.builder.append(", ");
            this.append(array[i]);
        }
        this.builder.append(']');
        return this;
    }

    public StringAppender appendArray(int[] array) {
        if (array == null) {
            this.appendNull();
            return this;
        }
        if (array.length == 0) {
            this.builder.append("[]");
            return this;
        }
        this.builder.append('[');
        this.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            this.builder.append(", ");
            this.append(array[i]);
        }
        this.builder.append(']');
        return this;
    }

    public StringAppender appendArray(long[] array) {
        if (array == null) {
            this.appendNull();
            return this;
        }
        if (array.length == 0) {
            this.builder.append("[]");
            return this;
        }
        this.builder.append('[');
        this.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            this.builder.append(", ");
            this.append(array[i]);
        }
        this.builder.append(']');
        return this;
    }

    public StringAppender appendArray(float[] array) {
        if (array == null) {
            this.appendNull();
            return this;
        }
        if (array.length == 0) {
            this.builder.append("[]");
            return this;
        }
        this.builder.append('[');
        this.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            this.builder.append(", ");
            this.append(array[i]);
        }
        this.builder.append(']');
        return this;
    }

    public StringAppender appendArray(double[] array) {
        if (array == null) {
            this.appendNull();
            return this;
        }
        if (array.length == 0) {
            this.builder.append("[]");
            return this;
        }
        this.builder.append('[');
        this.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            this.builder.append(", ");
            this.append(array[i]);
        }
        this.builder.append(']');
        return this;
    }

    public StringAppender appendCodePoint(int codePoint) {
        this.builder.appendCodePoint(codePoint);
        return this;
    }

    public StringAppender append(String str) {
        this.builder.append(str);
        return this;
    }

    public StringAppender append(StringBuffer buffer) {
        this.builder.append(buffer);
        return this;
    }

    public StringAppender append(StringSlice view) {
        if (view == null) {
            this.appendNull();
        } else {
            view.appendTo(this.builder);
        }
        return this;
    }

    public StringAppender append(StringSlice view, int beginIndex, int endIndex) {
        if (view == null) {
            this.appendNull();
        } else {
            view.appendTo(this.builder, beginIndex, endIndex);
        }
        return this;
    }

    @Override
    public StringAppender append(CharSequence s) {
        if (s instanceof StringSlice) {
            ((StringSlice)s).appendTo(this.builder);
        } else {
            this.builder.append(s);
        }
        return this;
    }

    @Override
    public StringAppender append(CharSequence s, int beginIndex, int endIndex) {
        if (s instanceof StringSlice) {
            ((StringSlice)s).appendTo(this.builder, beginIndex, endIndex);
        } else {
            this.builder.append(s);
        }
        return this;
    }

    public StringAppender appendFormatted(String format, Object ... args) {
        new Formatter(this).format(format, args);
        return this;
    }

    public StringAppender appendLowerCase(CharSequence str) {
        if (str == null) {
            this.appendNull();
            return this;
        }
        this.builder.append(str.toString().toLowerCase(Locale.ROOT));
        return this;
    }

    public StringAppender appendUpperCase(CharSequence str) {
        if (str == null) {
            this.appendNull();
            return this;
        }
        this.builder.append(str.toString().toUpperCase(Locale.ROOT));
        return this;
    }

    private void beforeAppend(int n) {
        this.builder.ensureCapacity(this.builder.length() + n);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.builder.toString());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.builder.setLength(0);
        this.builder.append((String)in.readObject());
    }

    public String toString() {
        return this.builder.toString();
    }
}

