/*
 * Decompiled with CFR 0.152.
 */
package kala.text;

import kala.text.StringSlice;
import org.jetbrains.annotations.NotNull;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean startsWith(@NotNull String str, @NotNull String prefix) {
        return str.startsWith(prefix);
    }

    public static boolean startsWith(@NotNull String str, @NotNull String prefix, int toIndex) {
        return str.startsWith(prefix, toIndex);
    }

    public static boolean startsWith(@NotNull String str, @NotNull StringSlice prefix) {
        return StringUtils.startsWith(str, prefix, 0);
    }

    public static boolean startsWith(@NotNull String str, @NotNull StringSlice prefix, int toIndex) {
        if (toIndex < 0 || toIndex > str.length() - prefix.length()) {
            return false;
        }
        return str.regionMatches(toIndex, prefix.source(), prefix.sourceOffset(), prefix.length());
    }

    public static boolean startsWith(@NotNull String str, @NotNull CharSequence prefix) {
        return StringUtils.startsWith(str, prefix, 0);
    }

    public static boolean startsWith(@NotNull String str, @NotNull CharSequence prefix, int toIndex) {
        return prefix instanceof StringSlice ? StringUtils.startsWith(str, (StringSlice)prefix, toIndex) : StringUtils.startsWith(str, prefix.toString(), toIndex);
    }

    public static boolean endsWith(@NotNull String str, @NotNull String prefix) {
        return str.endsWith(prefix);
    }

    public static boolean endsWith(@NotNull String str, @NotNull StringSlice prefix) {
        if (str.length() < prefix.length()) {
            return false;
        }
        return str.regionMatches(str.length() - prefix.length(), prefix.source(), prefix.sourceOffset(), prefix.length());
    }

    public static boolean endsWith(@NotNull String str, @NotNull CharSequence prefix) {
        return prefix instanceof StringSlice ? StringUtils.endsWith(str, (StringSlice)prefix) : StringUtils.endsWith(str, prefix.toString());
    }

    public static String removePrefix(@NotNull String str, @NotNull String prefix) {
        return str.startsWith(prefix) ? str.substring(prefix.length()) : str;
    }

    public static String removePrefix(@NotNull String str, @NotNull StringSlice prefix) {
        return StringUtils.startsWith(str, prefix) ? str.substring(prefix.length()) : str;
    }

    public static String removePrefix(@NotNull String str, @NotNull CharSequence prefix) {
        return StringUtils.startsWith(str, prefix) ? str.substring(prefix.length()) : str;
    }

    public static String removeSuffix(@NotNull String str, @NotNull String prefix) {
        return str.endsWith(prefix) ? str.substring(0, str.length() - prefix.length()) : str;
    }

    public static String removeSuffix(@NotNull String str, @NotNull StringSlice prefix) {
        return StringUtils.endsWith(str, prefix) ? str.substring(0, str.length() - prefix.length()) : str;
    }

    public static String removeSuffix(@NotNull String str, @NotNull CharSequence prefix) {
        return StringUtils.endsWith(str, prefix) ? str.substring(0, str.length() - prefix.length()) : str;
    }
}

