/*
 * Decompiled with CFR 0.152.
 */
package kala.value;

import java.util.function.Supplier;
import kala.value.Value;

public final class LateInitValue<T>
implements Value<T> {
    private volatile boolean initialized = false;
    private T value;

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(T value) {
        if (this.initialized) {
            throw new IllegalStateException("Value is initialized");
        }
        LateInitValue lateInitValue = this;
        synchronized (lateInitValue) {
            if (this.initialized) {
                throw new IllegalStateException("Value is initialized");
            }
            this.value = value;
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T computeIfUninitialized(Supplier<? extends T> supplier) {
        if (this.initialized) {
            return this.value;
        }
        LateInitValue lateInitValue = this;
        synchronized (lateInitValue) {
            if (this.initialized) {
                return this.value;
            }
            this.value = supplier.get();
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (!this.initialized) {
            LateInitValue lateInitValue = this;
            synchronized (lateInitValue) {
                if (!this.initialized) {
                    throw new IllegalStateException("Uninitialized LateInitValue");
                }
            }
        }
        return this.value;
    }

    public String toString() {
        if (this.initialized) {
            return "LateInitValue[" + String.valueOf(this.value) + "]";
        }
        return "LateInitValue[<uninitialized>]";
    }
}

