/*
 * Decompiled with CFR 0.152.
 */
package kala.value;

import kala.value.MutableValue;

public final class MutableLateInitValue<T>
implements MutableValue<T> {
    private volatile boolean initialized = false;
    private T value;

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void set(T value) {
        this.value = value;
        this.initialized = true;
    }

    @Override
    public T get() {
        if (!this.initialized) {
            throw new IllegalStateException("Uninitialized LateInitValue");
        }
        return this.value;
    }

    public String toString() {
        if (this.initialized) {
            return "MutableLateInitValue[" + String.valueOf(this.value) + "]";
        }
        return "MutableLateInitValue[<uninitialized>]";
    }
}

