/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.value.primitive.DefaultIntValue;
import kala.value.primitive.DelegateIntValue;
import kala.value.primitive.DelegateMutableIntValue;
import kala.value.primitive.LazyIntValue;
import kala.value.primitive.MutableIntValue;
import kala.value.primitive.PrimitiveValue;
import org.jetbrains.annotations.NotNull;

public interface IntValue
extends PrimitiveValue<Integer>,
IntTraversable,
IntSupplier {
    @NotNull
    public static IntValue of(int value) {
        return new DefaultIntValue(value);
    }

    @NotNull
    public static IntValue by(@NotNull IntSupplier getter) {
        Objects.requireNonNull(getter);
        return new DelegateIntValue(getter);
    }

    @NotNull
    public static LazyIntValue lazy(@NotNull IntSupplier getter) {
        return LazyIntValue.of(getter);
    }

    public int get();

    @Override
    @Deprecated
    default public int getAsInt() {
        return this.get();
    }

    @Override
    @NotNull
    default public Integer getValue() {
        return this.get();
    }

    @NotNull
    default public IntValue map(@NotNull IntUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return IntValue.by(() -> mapper.applyAsInt(this.get()));
    }

    @NotNull
    default public MutableIntValue asMutable(@NotNull IntConsumer setter) {
        Objects.requireNonNull(setter);
        return new DelegateMutableIntValue(this, setter);
    }

    @Override
    @NotNull
    default public IntIterator iterator() {
        return IntIterator.of(this.get());
    }

    @Override
    default public void forEach(@NotNull IntConsumer action) {
        action.accept(this.get());
    }
}

