/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.primitive.AbstractShortIterator;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.function.Memoized;
import kala.function.ShortFunction;
import kala.function.ShortSupplier;
import kala.function.ShortUnaryOperator;
import kala.value.LazyValue;
import kala.value.primitive.AbstractShortValue;
import kala.value.primitive.ShortValue;
import org.jetbrains.annotations.NotNull;

public class LazyShortValue
extends AbstractShortValue
implements ShortTraversable,
ShortValue,
ShortSupplier,
Memoized,
Serializable {
    private static final long serialVersionUID = 0L;
    private volatile transient ShortSupplier supplier;
    private transient short value;

    private LazyShortValue(ShortSupplier supplier) {
        this.supplier = supplier;
    }

    private LazyShortValue(short value) {
        this.value = value;
    }

    public static LazyShortValue of(@NotNull ShortSupplier supplier) {
        Objects.requireNonNull(supplier);
        return new LazyShortValue(supplier);
    }

    public static LazyShortValue ofValue(short value) {
        return new LazyShortValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short get() {
        if (this.supplier != null) {
            LazyShortValue lazyShortValue = this;
            synchronized (lazyShortValue) {
                ShortSupplier s = this.supplier;
                if (s != null) {
                    this.value = s.getAsShort();
                    this.supplier = null;
                }
            }
        }
        return this.value;
    }

    @Override
    public short getAsShort() {
        return this.get();
    }

    public boolean isReady() {
        return this.supplier == null;
    }

    @Override
    @NotNull
    public LazyShortValue map(@NotNull ShortUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return LazyShortValue.of(() -> mapper.applyAsShort(this.get()));
    }

    public <U> LazyValue<U> mapToObj(@NotNull ShortFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return LazyValue.of(() -> mapper.apply(this.get()));
    }

    @Override
    @NotNull
    public ShortIterator iterator() {
        return new AbstractShortIterator(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public short nextShort() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return LazyShortValue.this.get();
            }
        };
    }

    @Override
    public String toString() {
        if (this.supplier == null) {
            return "LazyShortValue[" + this.value + "]";
        }
        return "LazyShortValue[<not computed>]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.value = in.readShort();
        this.supplier = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeShort(this.get());
    }
}

