/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.util.Objects;
import kala.function.CharBinaryOperator;
import kala.function.CharConsumer;
import kala.function.CharSupplier;
import kala.function.CharUnaryOperator;
import kala.value.primitive.CharValue;
import kala.value.primitive.CharVar;
import kala.value.primitive.DelegateMutableCharValue;
import kala.value.primitive.MutablePrimitiveValue;
import kala.value.primitive.VolatileCharVar;
import org.jetbrains.annotations.NotNull;

public interface MutableCharValue
extends MutablePrimitiveValue<Character>,
CharValue,
CharConsumer {
    @NotNull
    public static MutableCharValue create() {
        return new CharVar();
    }

    @NotNull
    public static MutableCharValue create(char initialValue) {
        return new CharVar(initialValue);
    }

    @NotNull
    public static MutableCharValue createVolatile() {
        return new VolatileCharVar();
    }

    @NotNull
    public static MutableCharValue createVolatile(char initialValue) {
        return new VolatileCharVar(initialValue);
    }

    @NotNull
    public static MutableCharValue by(@NotNull CharSupplier getter, @NotNull CharConsumer setter) {
        Objects.requireNonNull(getter);
        Objects.requireNonNull(setter);
        return new DelegateMutableCharValue(getter, setter);
    }

    public void set(char var1);

    @Override
    default public void setValue(@NotNull Character value) {
        this.set(value.charValue());
    }

    @Override
    @Deprecated
    default public void accept(char value) {
        this.set(value);
    }

    @NotNull
    default public MutableCharValue withGetter(@NotNull CharSupplier newGetter) {
        Objects.requireNonNull(newGetter);
        return new DelegateMutableCharValue(newGetter, this);
    }

    @NotNull
    default public MutableCharValue withSetter(@NotNull CharConsumer newSetter) {
        Objects.requireNonNull(newSetter);
        return new DelegateMutableCharValue(this, newSetter);
    }

    @Override
    @Deprecated
    @NotNull
    default public MutableCharValue asMutable(@NotNull CharConsumer setter) {
        return this.withSetter(setter);
    }

    default public char getAndSet(char newValue) {
        char oldValue = this.get();
        this.set(newValue);
        return oldValue;
    }

    default public boolean compareAndSet(char expectedValue, char newValue) {
        if (this.get() == expectedValue) {
            this.set(newValue);
            return true;
        }
        return false;
    }

    default public void update(@NotNull CharUnaryOperator updateFunction) {
        this.getAndUpdate(updateFunction);
    }

    default public char getAndUpdate(@NotNull CharUnaryOperator updateFunction) {
        char v = this.get();
        this.set(updateFunction.applyAsChar(v));
        return v;
    }

    default public char updateAndGet(@NotNull CharUnaryOperator updateFunction) {
        char v = updateFunction.applyAsChar(this.get());
        this.set(v);
        return v;
    }

    default public void accumulate(char t, @NotNull CharBinaryOperator accumulatorFunction) {
        this.getAndAccumulate(t, accumulatorFunction);
    }

    default public char getAndAccumulate(char t, @NotNull CharBinaryOperator accumulatorFunction) {
        char v = this.get();
        this.set(accumulatorFunction.applyAsChar(v, t));
        return v;
    }

    default public char accumulateAndGet(char t, @NotNull CharBinaryOperator accumulatorFunction) {
        char v = accumulatorFunction.applyAsChar(this.get(), t);
        this.set(v);
        return v;
    }
}

