/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.Objects;
import kala.collection.base.AnyTraversable;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.factory.primitive.BooleanCollectionFactory;
import kala.collection.immutable.primitive.ImmutableBooleanCollection;
import kala.collection.primitive.AbstractBooleanCollection;
import kala.function.BooleanFunction;
import kala.function.BooleanPredicate;
import kala.function.BooleanUnaryOperator;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImmutableBooleanCollection
extends AbstractBooleanCollection
implements ImmutableBooleanCollection {
    static <T, Builder> T filter(@NotNull ImmutableBooleanCollection collection, @NotNull BooleanPredicate predicate, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            if (predicate.test(e)) {
                factory.addToBuilder(builder, e);
            }
        });
        return (T)factory.build(builder);
    }

    static <T, Builder> T filterNot(@NotNull ImmutableBooleanCollection collection, @NotNull BooleanPredicate predicate, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            if (!predicate.test(e)) {
                factory.addToBuilder(builder, e);
            }
        });
        return (T)factory.build(builder);
    }

    static <U, T, Builder> T map(@NotNull ImmutableBooleanCollection collection, @NotNull BooleanUnaryOperator mapper, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)collection);
        collection.forEach(e -> factory.addToBuilder(builder, mapper.applyAsBoolean(e)));
        return (T)factory.build(builder);
    }

    static <T, Builder> T flatMap(@NotNull ImmutableBooleanCollection collection, @NotNull BooleanFunction<? extends BooleanTraversable> mapper, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            BooleanTraversable us = (BooleanTraversable)mapper.apply(e);
            factory.sizeHint(builder, (AnyTraversable)us);
            us.forEach(u -> factory.addToBuilder(builder, u));
        });
        return (T)factory.build(builder);
    }
}

