/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.Objects;
import kala.collection.base.AnyTraversable;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.factory.primitive.CharCollectionFactory;
import kala.collection.immutable.primitive.ImmutableCharCollection;
import kala.collection.primitive.AbstractCharCollection;
import kala.function.CharFunction;
import kala.function.CharPredicate;
import kala.function.CharUnaryOperator;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImmutableCharCollection
extends AbstractCharCollection
implements ImmutableCharCollection {
    static <T, Builder> T filter(@NotNull ImmutableCharCollection collection, @NotNull CharPredicate predicate, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            if (predicate.test(e)) {
                factory.addToBuilder(builder, e);
            }
        });
        return (T)factory.build(builder);
    }

    static <T, Builder> T filterNot(@NotNull ImmutableCharCollection collection, @NotNull CharPredicate predicate, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            if (!predicate.test(e)) {
                factory.addToBuilder(builder, e);
            }
        });
        return (T)factory.build(builder);
    }

    static <U, T, Builder> T map(@NotNull ImmutableCharCollection collection, @NotNull CharUnaryOperator mapper, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)collection);
        collection.forEach(e -> factory.addToBuilder(builder, mapper.applyAsChar(e)));
        return (T)factory.build(builder);
    }

    static <T, Builder> T flatMap(@NotNull ImmutableCharCollection collection, @NotNull CharFunction<? extends CharTraversable> mapper, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            CharTraversable us = (CharTraversable)mapper.apply(e);
            factory.sizeHint(builder, (AnyTraversable)us);
            us.forEach(u -> factory.addToBuilder(builder, u));
        });
        return (T)factory.build(builder);
    }
}

