/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import kala.collection.base.AnyTraversable;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.collection.immutable.primitive.ImmutableIntCollection;
import kala.collection.primitive.AbstractIntCollection;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImmutableIntCollection
extends AbstractIntCollection
implements ImmutableIntCollection {
    static <T, Builder> T filter(@NotNull ImmutableIntCollection collection, @NotNull IntPredicate predicate, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            if (predicate.test(e)) {
                factory.addToBuilder(builder, e);
            }
        });
        return (T)factory.build(builder);
    }

    static <T, Builder> T filterNot(@NotNull ImmutableIntCollection collection, @NotNull IntPredicate predicate, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            if (!predicate.test(e)) {
                factory.addToBuilder(builder, e);
            }
        });
        return (T)factory.build(builder);
    }

    static <U, T, Builder> T map(@NotNull ImmutableIntCollection collection, @NotNull IntUnaryOperator mapper, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)collection);
        collection.forEach(e -> factory.addToBuilder(builder, mapper.applyAsInt(e)));
        return (T)factory.build(builder);
    }

    static <T, Builder> T flatMap(@NotNull ImmutableIntCollection collection, @NotNull IntFunction<? extends IntTraversable> mapper, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            IntTraversable us = (IntTraversable)mapper.apply(e);
            factory.sizeHint(builder, (AnyTraversable)us);
            us.forEach(u -> factory.addToBuilder(builder, u));
        });
        return (T)factory.build(builder);
    }
}

