/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.Objects;
import java.util.function.LongPredicate;
import kala.Conditions;
import kala.collection.base.AnyTraversable;
import kala.collection.base.primitive.LongArrays;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.collection.factory.primitive.LongCollectionFactory;
import kala.collection.immutable.primitive.ImmutableLongSeq;
import kala.collection.primitive.AbstractLongSeq;
import kala.collection.primitive.LongSeqLike;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImmutableLongSeq
extends AbstractLongSeq
implements ImmutableLongSeq {
    static <T, Builder> T updated(@NotNull ImmutableLongSeq seq, int index, long newValue, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        int s = seq.size();
        if (index < 0 || index >= s) {
            throw new IndexOutOfBoundsException();
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, s);
        LongIterator it = seq.iterator();
        while (it.hasNext()) {
            long e = it.nextLong();
            if (index-- == 0) {
                factory.addToBuilder(builder, newValue);
                continue;
            }
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <T extends ImmutableLongSeq, Builder> T slice(@NotNull ImmutableLongSeq seq, int beginIndex, int endIndex, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        int size = seq.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int ns = endIndex - beginIndex;
        if (ns == 0) {
            return (T)((ImmutableLongSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = beginIndex; i < endIndex; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            LongIterator it = seq.iterator().drop(beginIndex).take(ns);
            while (it.hasNext()) {
                factory.addToBuilder(builder, it.nextLong());
            }
        }
        return (T)((ImmutableLongSeq)factory.build(builder));
    }

    static <T extends ImmutableLongSeq, Builder> T drop(@NotNull ImmutableLongSeq seq, int n, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s >= 0) {
            factory.sizeHint(builder, Integer.max(s - n, 0));
        }
        LongIterator it = seq.iterator().drop(n);
        while (it.hasNext()) {
            long e = it.nextLong();
            factory.addToBuilder(builder, e);
        }
        return (T)((ImmutableLongSeq)factory.build(builder));
    }

    static <T extends ImmutableLongSeq, Builder> T dropLast(@NotNull ImmutableLongSeq seq, int n, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)seq;
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)((ImmutableLongSeq)factory.empty());
        }
        int ns = ss - n;
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            LongIterator it = seq.iterator();
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, it.nextLong());
            }
        }
        return (T)((ImmutableLongSeq)factory.build(builder));
    }

    static <T extends ImmutableLongSeq, Builder> T dropWhile(@NotNull ImmutableLongSeq seq, @NotNull LongPredicate predicate, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        factory.addAllToBuilder(builder, seq.iterator().dropWhile(predicate));
        return (T)((ImmutableLongSeq)factory.build(builder));
    }

    static <T extends ImmutableLongSeq, Builder> T take(@NotNull ImmutableLongSeq seq, int n, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableLongSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s != -1) {
            factory.sizeHint(builder, Integer.min(s, n));
        }
        int count = 0;
        LongIterator it = seq.iterator();
        while (it.hasNext() && ++count <= n) {
            factory.addToBuilder(builder, it.nextLong());
        }
        return (T)((ImmutableLongSeq)factory.build(builder));
    }

    static <T extends ImmutableLongSeq, Builder> T takeLast(@NotNull ImmutableLongSeq seq, int n, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableLongSeq)factory.empty());
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)seq;
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, n);
        if (seq.supportsFastRandomAccess()) {
            for (int i = ss - n; i < ss; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            LongIterator it = seq.iterator();
            for (int i = 0; i < ss - n; ++i) {
                it.nextLong();
            }
            while (it.hasNext()) {
                factory.addToBuilder(builder, it.nextLong());
            }
        }
        return (T)((ImmutableLongSeq)factory.build(builder));
    }

    static <T extends ImmutableLongSeq, Builder> T takeWhile(@NotNull ImmutableLongSeq seq, @NotNull LongPredicate predicate, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        seq.forEachBreakable(e -> {
            if (!predicate.test(e)) {
                return false;
            }
            factory.addToBuilder(builder, e);
            return true;
        });
        return (T)((ImmutableLongSeq)factory.build(builder));
    }

    static <T extends ImmutableLongSeq, Builder> T concat(@NotNull ImmutableLongSeq seq, @NotNull LongSeqLike other, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(other);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (LongTraversable)seq);
        factory.sizeHint(builder, (AnyTraversable)other);
        factory.addAllToBuilder(builder, (LongTraversable)other);
        return (T)((ImmutableLongSeq)factory.build(builder));
    }

    static <T, Builder> T prepended(@NotNull ImmutableLongSeq seq, long element, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, 1);
        factory.addToBuilder(builder, element);
        factory.addAllToBuilder(builder, (LongTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T prependedAll(@NotNull ImmutableLongSeq seq, long @NotNull [] values, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, values.length);
        for (long e : values) {
            factory.addToBuilder(builder, e);
        }
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (LongTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T prependedAll(@NotNull ImmutableLongSeq seq, @NotNull LongTraversable values, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)values);
        factory.addAllToBuilder(builder, values);
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (LongTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T appended(@NotNull ImmutableLongSeq seq, long element, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, 1);
        factory.addAllToBuilder(builder, (LongTraversable)seq);
        factory.addToBuilder(builder, element);
        return (T)factory.build(builder);
    }

    static <T, Builder> T appendedAll(@NotNull ImmutableLongSeq seq, long @NotNull [] values, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, values.length);
        factory.addAllToBuilder(builder, (LongTraversable)seq);
        for (long e : values) {
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <T, Builder> T appendedAll(@NotNull ImmutableLongSeq seq, @NotNull LongTraversable values, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (LongTraversable)seq);
        factory.sizeHint(builder, (AnyTraversable)values);
        factory.addAllToBuilder(builder, values);
        return (T)factory.build(builder);
    }

    static <T, Builder> T sorted(@NotNull ImmutableLongSeq seq, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        if (seq.isEmpty()) {
            return (T)factory.empty();
        }
        long[] arr = seq.toArray();
        LongArrays.sort((long[])arr);
        return (T)factory.from(arr);
    }

    static <T, Builder> T reversed(@NotNull ImmutableLongSeq seq, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, seq.reverseIterator());
        return (T)factory.build(builder);
    }
}

