/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import kala.collection.base.primitive.CharArrays;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.factory.primitive.CharCollectionFactory;
import kala.collection.immutable.primitive.ImmutableCharSeq;
import kala.collection.mutable.primitive.MutableCharArrayList;
import kala.collection.primitive.CharArraySeq;
import kala.function.CharSupplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ImmutableCharArray
extends CharArraySeq
implements ImmutableCharSeq,
Serializable {
    private static final long serialVersionUID = 1845940935381169058L;
    public static final ImmutableCharArray EMPTY = new ImmutableCharArray(CharArrays.EMPTY);
    private static final Factory FACTORY = new Factory();

    ImmutableCharArray(char @NotNull [] elements) {
        super(elements);
    }

    @NotNull
    public static CharCollectionFactory<?, ? extends ImmutableCharArray> factory() {
        return FACTORY;
    }

    @NotNull
    public static ImmutableCharArray empty() {
        return EMPTY;
    }

    @NotNull
    public static ImmutableCharArray of() {
        return ImmutableCharArray.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ImmutableCharArray of(char value1) {
        return new ImmutableCharArray(new char[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ImmutableCharArray of(char value1, char value2) {
        return new ImmutableCharArray(new char[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableCharArray of(char value1, char value2, char value3) {
        return new ImmutableCharArray(new char[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableCharArray of(char value1, char value2, char value3, char value4) {
        return new ImmutableCharArray(new char[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableCharArray of(char value1, char value2, char value3, char value4, char value5) {
        return new ImmutableCharArray(new char[]{value1, value2, value3, value4, value5});
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableCharArray of(char ... values) {
        return ImmutableCharArray.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableCharArray from(char @NotNull [] values) {
        return values.length == 0 ? ImmutableCharArray.empty() : new ImmutableCharArray((char[])values.clone());
    }

    @NotNull
    public static ImmutableCharArray from(@NotNull CharTraversable values) {
        if (values instanceof ImmutableCharArray) {
            return (ImmutableCharArray)values;
        }
        if (values.isEmpty()) {
            return ImmutableCharArray.empty();
        }
        char[] arr = values.toArray();
        return arr.length == 0 ? ImmutableCharArray.empty() : new ImmutableCharArray(arr);
    }

    @NotNull
    public static ImmutableCharArray from(@NotNull CharIterator it) {
        if (!it.hasNext()) {
            return ImmutableCharArray.empty();
        }
        return new ImmutableCharArray(it.toArray());
    }

    @NotNull
    public static ImmutableCharArray fill(int n, char value) {
        if (n <= 0) {
            return ImmutableCharArray.empty();
        }
        char[] ans = new char[n];
        if (value != '\u0000') {
            Arrays.fill(ans, value);
        }
        return new ImmutableCharArray(ans);
    }

    @NotNull
    public static ImmutableCharArray fill(int n, @NotNull CharSupplier supplier) {
        if (n <= 0) {
            return ImmutableCharArray.empty();
        }
        char[] ans = new char[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsChar();
        }
        return new ImmutableCharArray(ans);
    }

    char @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableCharArray";
    }

    private static final class Factory
    implements CharCollectionFactory<MutableCharArrayList, ImmutableCharArray> {
        private Factory() {
        }

        public ImmutableCharArray empty() {
            return ImmutableCharArray.empty();
        }

        public ImmutableCharArray from(char @NotNull [] values) {
            return ImmutableCharArray.from(values);
        }

        public ImmutableCharArray from(@NotNull CharTraversable values) {
            return ImmutableCharArray.from(values);
        }

        public ImmutableCharArray from(@NotNull CharIterator it) {
            return ImmutableCharArray.from(it);
        }

        public ImmutableCharArray fill(int n, char value) {
            return ImmutableCharArray.fill(n, value);
        }

        public ImmutableCharArray fill(int n, @NotNull CharSupplier supplier) {
            return ImmutableCharArray.fill(n, supplier);
        }

        public MutableCharArrayList newBuilder() {
            return new MutableCharArrayList();
        }

        public void addToBuilder(@NotNull MutableCharArrayList buffer, char value) {
            buffer.append(value);
        }

        public MutableCharArrayList mergeBuilder(@NotNull MutableCharArrayList builder1, @NotNull MutableCharArrayList builder2) {
            builder1.appendAll(builder2);
            return builder1;
        }

        public void sizeHint(@NotNull MutableCharArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public ImmutableCharArray build(@NotNull MutableCharArrayList buffer) {
            return new ImmutableCharArray(buffer.toArray());
        }
    }

    public static final class Unsafe {
        private Unsafe() {
        }

        @Contract(value="_ -> new")
        @NotNull
        public static ImmutableCharArray wrap(char @NotNull [] array) {
            Objects.requireNonNull(array);
            return new ImmutableCharArray(array);
        }
    }
}

