/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.collection.factory.primitive.FloatCollectionFactory;
import kala.collection.immutable.primitive.AbstractImmutableFloatCollection;
import kala.collection.immutable.primitive.AbstractImmutableFloatSet;
import kala.collection.immutable.primitive.ImmutableFloatCollection;
import kala.collection.immutable.primitive.ImmutablePrimitiveSet;
import kala.collection.immutable.primitive.ImmutableSortedFloatArraySet;
import kala.collection.primitive.FloatArraySeq;
import kala.collection.primitive.FloatSet;
import kala.function.FloatPredicate;
import org.jetbrains.annotations.NotNull;

public interface ImmutableFloatSet
extends ImmutablePrimitiveSet<Float>,
FloatSet,
ImmutableFloatCollection {
    public static FloatCollectionFactory<?, ImmutableFloatSet> factory() {
        return FloatCollectionFactory.narrow(ImmutableSortedFloatArraySet.factory());
    }

    @NotNull
    public static ImmutableFloatSet empty() {
        return ImmutableSortedFloatArraySet.empty();
    }

    @NotNull
    public static ImmutableFloatSet of() {
        return ImmutableSortedFloatArraySet.of();
    }

    @NotNull
    public static ImmutableFloatSet of(float value1) {
        return ImmutableSortedFloatArraySet.of(value1);
    }

    @NotNull
    public static ImmutableFloatSet of(float value1, float value2) {
        return ImmutableSortedFloatArraySet.of(value1, value2);
    }

    @NotNull
    public static ImmutableFloatSet of(float value1, float value2, float value3) {
        return ImmutableSortedFloatArraySet.of(value1, value2, value3);
    }

    @NotNull
    public static ImmutableFloatSet of(float value1, float value2, float value3, float value4) {
        return ImmutableSortedFloatArraySet.of(value1, value2, value3, value4);
    }

    @NotNull
    public static ImmutableFloatSet of(float value1, float value2, float value3, float value4, float value5) {
        return ImmutableSortedFloatArraySet.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static ImmutableFloatSet of(float ... values) {
        return ImmutableSortedFloatArraySet.of(values);
    }

    @NotNull
    public static ImmutableFloatSet from(float @NotNull [] values) {
        return ImmutableSortedFloatArraySet.from(values);
    }

    @NotNull
    public static ImmutableFloatSet from(@NotNull FloatTraversable values) {
        return ImmutableSortedFloatArraySet.from(values);
    }

    @NotNull
    public static ImmutableFloatSet from(@NotNull FloatIterator it) {
        return ImmutableSortedFloatArraySet.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "ImmutableFloatSet";
    }

    @NotNull
    default public FloatCollectionFactory<?, ? extends ImmutableFloatSet> iterableFactory() {
        return ImmutableFloatSet.factory();
    }

    @NotNull
    default public ImmutableFloatSet added(float value) {
        if (this.contains(value)) {
            return this;
        }
        return AbstractImmutableFloatSet.added(this, value, this.iterableFactory());
    }

    @NotNull
    default public ImmutableFloatSet addedAll(@NotNull FloatTraversable values) {
        return AbstractImmutableFloatSet.addedAll(this, values, this.iterableFactory());
    }

    @NotNull
    default public ImmutableFloatSet addedAll(float @NotNull [] values) {
        return this.addedAll(FloatArraySeq.wrap(values));
    }

    @Override
    @NotNull
    default public ImmutableFloatSet filter(@NotNull FloatPredicate predicate) {
        return AbstractImmutableFloatCollection.filter(this, predicate, ImmutableFloatSet.factory());
    }

    @Override
    @NotNull
    default public ImmutableFloatSet filterNot(@NotNull FloatPredicate predicate) {
        return AbstractImmutableFloatCollection.filterNot(this, predicate, ImmutableFloatSet.factory());
    }
}

