/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import kala.collection.base.primitive.ShortArrays;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.collection.factory.primitive.ShortCollectionFactory;
import kala.collection.immutable.primitive.ImmutableShortSeq;
import kala.collection.mutable.primitive.MutableShortArrayList;
import kala.collection.primitive.ShortArraySeq;
import kala.function.ShortSupplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ImmutableShortArray
extends ShortArraySeq
implements ImmutableShortSeq,
Serializable {
    private static final long serialVersionUID = 1845940935381169058L;
    public static final ImmutableShortArray EMPTY = new ImmutableShortArray(ShortArrays.EMPTY);
    private static final Factory FACTORY = new Factory();

    ImmutableShortArray(short @NotNull [] elements) {
        super(elements);
    }

    @NotNull
    public static ShortCollectionFactory<?, ? extends ImmutableShortArray> factory() {
        return FACTORY;
    }

    @NotNull
    public static ImmutableShortArray empty() {
        return EMPTY;
    }

    @NotNull
    public static ImmutableShortArray of() {
        return ImmutableShortArray.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ImmutableShortArray of(short value1) {
        return new ImmutableShortArray(new short[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ImmutableShortArray of(short value1, short value2) {
        return new ImmutableShortArray(new short[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableShortArray of(short value1, short value2, short value3) {
        return new ImmutableShortArray(new short[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableShortArray of(short value1, short value2, short value3, short value4) {
        return new ImmutableShortArray(new short[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableShortArray of(short value1, short value2, short value3, short value4, short value5) {
        return new ImmutableShortArray(new short[]{value1, value2, value3, value4, value5});
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableShortArray of(short ... values) {
        return ImmutableShortArray.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableShortArray from(short @NotNull [] values) {
        return values.length == 0 ? ImmutableShortArray.empty() : new ImmutableShortArray((short[])values.clone());
    }

    @NotNull
    public static ImmutableShortArray from(@NotNull ShortTraversable values) {
        if (values instanceof ImmutableShortArray) {
            return (ImmutableShortArray)values;
        }
        if (values.isEmpty()) {
            return ImmutableShortArray.empty();
        }
        short[] arr = values.toArray();
        return arr.length == 0 ? ImmutableShortArray.empty() : new ImmutableShortArray(arr);
    }

    @NotNull
    public static ImmutableShortArray from(@NotNull ShortIterator it) {
        if (!it.hasNext()) {
            return ImmutableShortArray.empty();
        }
        return new ImmutableShortArray(it.toArray());
    }

    @NotNull
    public static ImmutableShortArray fill(int n, short value) {
        if (n <= 0) {
            return ImmutableShortArray.empty();
        }
        short[] ans = new short[n];
        if (value != 0) {
            Arrays.fill(ans, value);
        }
        return new ImmutableShortArray(ans);
    }

    @NotNull
    public static ImmutableShortArray fill(int n, @NotNull ShortSupplier supplier) {
        if (n <= 0) {
            return ImmutableShortArray.empty();
        }
        short[] ans = new short[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsShort();
        }
        return new ImmutableShortArray(ans);
    }

    short @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableShortArray";
    }

    private static final class Factory
    implements ShortCollectionFactory<MutableShortArrayList, ImmutableShortArray> {
        private Factory() {
        }

        public ImmutableShortArray empty() {
            return ImmutableShortArray.empty();
        }

        public ImmutableShortArray from(short @NotNull [] values) {
            return ImmutableShortArray.from(values);
        }

        public ImmutableShortArray from(@NotNull ShortTraversable values) {
            return ImmutableShortArray.from(values);
        }

        public ImmutableShortArray from(@NotNull ShortIterator it) {
            return ImmutableShortArray.from(it);
        }

        public ImmutableShortArray fill(int n, short value) {
            return ImmutableShortArray.fill(n, value);
        }

        public ImmutableShortArray fill(int n, @NotNull ShortSupplier supplier) {
            return ImmutableShortArray.fill(n, supplier);
        }

        public MutableShortArrayList newBuilder() {
            return new MutableShortArrayList();
        }

        public void addToBuilder(@NotNull MutableShortArrayList buffer, short value) {
            buffer.append(value);
        }

        public MutableShortArrayList mergeBuilder(@NotNull MutableShortArrayList builder1, @NotNull MutableShortArrayList builder2) {
            builder1.appendAll(builder2);
            return builder1;
        }

        public void sizeHint(@NotNull MutableShortArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public ImmutableShortArray build(@NotNull MutableShortArrayList buffer) {
            return new ImmutableShortArray(buffer.toArray());
        }
    }

    public static final class Unsafe {
        private Unsafe() {
        }

        @Contract(value="_ -> new")
        @NotNull
        public static ImmutableShortArray wrap(short @NotNull [] array) {
            Objects.requireNonNull(array);
            return new ImmutableShortArray(array);
        }
    }
}

