/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.DoubleConsumer;
import kala.collection.base.primitive.DoubleArrays;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.factory.primitive.DoubleCollectionFactory;
import kala.collection.immutable.primitive.AbstractImmutableDoubleSet;
import kala.collection.mutable.primitive.MutableDoubleTreeSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ImmutableSortedDoubleArraySet
extends AbstractImmutableDoubleSet
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final Factory FACTORY = new Factory();
    private static final ImmutableSortedDoubleArraySet EMPTY = new ImmutableSortedDoubleArraySet(DoubleArrays.EMPTY);
    final double[] elements;

    ImmutableSortedDoubleArraySet(double[] elements) {
        this.elements = elements;
    }

    @NotNull
    public static DoubleCollectionFactory<?, ImmutableSortedDoubleArraySet> factory() {
        return FACTORY;
    }

    @Contract
    @NotNull
    public static ImmutableSortedDoubleArraySet empty() {
        return EMPTY;
    }

    @NotNull
    public static ImmutableSortedDoubleArraySet of() {
        return ImmutableSortedDoubleArraySet.empty();
    }

    @NotNull
    public static ImmutableSortedDoubleArraySet of(double value1) {
        return new ImmutableSortedDoubleArraySet(new double[]{value1});
    }

    @NotNull
    public static ImmutableSortedDoubleArraySet of(double value1, double value2) {
        int c = Double.compare(value1, value2);
        if (c < 0) {
            return new ImmutableSortedDoubleArraySet(new double[]{value1, value2});
        }
        if (c > 0) {
            return new ImmutableSortedDoubleArraySet(new double[]{value2, value1});
        }
        return new ImmutableSortedDoubleArraySet(new double[]{value1});
    }

    @NotNull
    public static ImmutableSortedDoubleArraySet of(double value1, double value2, double value3) {
        MutableDoubleTreeSet s = new MutableDoubleTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        return new ImmutableSortedDoubleArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedDoubleArraySet of(double value1, double value2, double value3, double value4) {
        MutableDoubleTreeSet s = new MutableDoubleTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        return new ImmutableSortedDoubleArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedDoubleArraySet of(double value1, double value2, double value3, double value4, double value5) {
        MutableDoubleTreeSet s = new MutableDoubleTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        s.add(value5);
        return new ImmutableSortedDoubleArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedDoubleArraySet of(double ... values) {
        return ImmutableSortedDoubleArraySet.from(values);
    }

    @NotNull
    public static ImmutableSortedDoubleArraySet from(double @NotNull [] values) {
        if (values.length == 0) {
            return ImmutableSortedDoubleArraySet.empty();
        }
        MutableDoubleTreeSet s = new MutableDoubleTreeSet();
        s.addAll(values);
        return new ImmutableSortedDoubleArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedDoubleArraySet from(@NotNull DoubleTraversable values) {
        return ImmutableSortedDoubleArraySet.from(values.iterator());
    }

    @NotNull
    public static ImmutableSortedDoubleArraySet from(@NotNull DoubleIterator it) {
        if (!it.hasNext()) {
            return ImmutableSortedDoubleArraySet.empty();
        }
        MutableDoubleTreeSet s = new MutableDoubleTreeSet();
        while (it.hasNext()) {
            s.add(it.nextDouble());
        }
        return new ImmutableSortedDoubleArraySet(s.toArray());
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableSortedDoubleArraySet";
    }

    @NotNull
    public DoubleCollectionFactory<?, ImmutableSortedDoubleArraySet> iterableFactory() {
        return FACTORY;
    }

    @NotNull
    public DoubleIterator iterator() {
        return DoubleArrays.iterator((double[])this.elements);
    }

    public int size() {
        return this.elements.length;
    }

    public int knownSize() {
        return this.size();
    }

    @Override
    @NotNull
    public ImmutableSortedDoubleArraySet added(double value) {
        int size = this.elements.length;
        if (size == 0) {
            return new ImmutableSortedDoubleArraySet(new double[]{value});
        }
        int idx = Arrays.binarySearch(this.elements, value);
        if (idx >= 0) {
            return this;
        }
        idx = -idx - 1;
        double[] newElements = new double[size + 1];
        if (idx == 0) {
            System.arraycopy(this.elements, 0, newElements, 1, size);
            newElements[0] = value;
            return new ImmutableSortedDoubleArraySet(newElements);
        }
        if (idx == size) {
            System.arraycopy(this.elements, 0, newElements, 0, size);
            newElements[size] = value;
            return new ImmutableSortedDoubleArraySet(newElements);
        }
        System.arraycopy(this.elements, 0, newElements, 0, idx);
        System.arraycopy(this.elements, idx, newElements, idx + 1, size - idx);
        newElements[idx] = value;
        return new ImmutableSortedDoubleArraySet(newElements);
    }

    @Override
    @NotNull
    public ImmutableSortedDoubleArraySet addedAll(@NotNull DoubleTraversable values) {
        DoubleIterator it = values.iterator();
        if (!it.hasNext()) {
            return this;
        }
        double[] elements = this.elements;
        if (elements.length == 0) {
            return ImmutableSortedDoubleArraySet.from(values);
        }
        MutableDoubleTreeSet builder = new MutableDoubleTreeSet();
        builder.addAll(elements);
        builder.addAll(values);
        if (builder.size() == elements.length) {
            return this;
        }
        return new ImmutableSortedDoubleArraySet(builder.toArray());
    }

    @Override
    @NotNull
    public ImmutableSortedDoubleArraySet addedAll(double @NotNull [] values) {
        int arrayLength = values.length;
        if (arrayLength == 0) {
            return this;
        }
        if (arrayLength == 1) {
            return this.added(values[0]);
        }
        int size = this.elements.length;
        if (size == 0) {
            return ImmutableSortedDoubleArraySet.from(values);
        }
        MutableDoubleTreeSet builder = new MutableDoubleTreeSet();
        builder.addAll(this.elements);
        builder.addAll(values);
        return new ImmutableSortedDoubleArraySet(builder.toArray());
    }

    public double first() {
        if (this.elements.length == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[0];
    }

    public double last() {
        int size = this.elements.length;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[size - 1];
    }

    @NotNull
    public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return (A)DoubleArrays.joinTo((double[])this.elements, buffer, (CharSequence)separator, (CharSequence)prefix, (CharSequence)postfix);
    }

    public void forEach(@NotNull DoubleConsumer action) {
        for (double e : this.elements) {
            action.accept(e);
        }
    }

    private static final class Factory
    implements DoubleCollectionFactory<MutableDoubleTreeSet, ImmutableSortedDoubleArraySet> {
        private Factory() {
        }

        public ImmutableSortedDoubleArraySet empty() {
            return ImmutableSortedDoubleArraySet.empty();
        }

        public MutableDoubleTreeSet newBuilder() {
            return new MutableDoubleTreeSet();
        }

        public ImmutableSortedDoubleArraySet build(@NotNull MutableDoubleTreeSet builder) {
            return builder.isEmpty() ? ImmutableSortedDoubleArraySet.empty() : new ImmutableSortedDoubleArraySet(builder.toArray());
        }

        public void addToBuilder(@NotNull MutableDoubleTreeSet builder, double value) {
            builder.add(value);
        }

        public MutableDoubleTreeSet mergeBuilder(@NotNull MutableDoubleTreeSet builder1, @NotNull MutableDoubleTreeSet builder2) {
            builder1.addAll(builder2);
            return builder1;
        }
    }
}

