/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import kala.collection.base.primitive.ShortArrays;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.collection.factory.primitive.ShortCollectionFactory;
import kala.collection.immutable.primitive.AbstractImmutableShortSet;
import kala.collection.mutable.primitive.MutableShortTreeSet;
import kala.function.ShortConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ImmutableSortedShortArraySet
extends AbstractImmutableShortSet
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final Factory FACTORY = new Factory();
    private static final ImmutableSortedShortArraySet EMPTY = new ImmutableSortedShortArraySet(ShortArrays.EMPTY);
    final short[] elements;

    ImmutableSortedShortArraySet(short[] elements) {
        this.elements = elements;
    }

    @NotNull
    public static ShortCollectionFactory<?, ImmutableSortedShortArraySet> factory() {
        return FACTORY;
    }

    @Contract
    @NotNull
    public static ImmutableSortedShortArraySet empty() {
        return EMPTY;
    }

    @NotNull
    public static ImmutableSortedShortArraySet of() {
        return ImmutableSortedShortArraySet.empty();
    }

    @NotNull
    public static ImmutableSortedShortArraySet of(short value1) {
        return new ImmutableSortedShortArraySet(new short[]{value1});
    }

    @NotNull
    public static ImmutableSortedShortArraySet of(short value1, short value2) {
        int c = Short.compare(value1, value2);
        if (c < 0) {
            return new ImmutableSortedShortArraySet(new short[]{value1, value2});
        }
        if (c > 0) {
            return new ImmutableSortedShortArraySet(new short[]{value2, value1});
        }
        return new ImmutableSortedShortArraySet(new short[]{value1});
    }

    @NotNull
    public static ImmutableSortedShortArraySet of(short value1, short value2, short value3) {
        MutableShortTreeSet s = new MutableShortTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        return new ImmutableSortedShortArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedShortArraySet of(short value1, short value2, short value3, short value4) {
        MutableShortTreeSet s = new MutableShortTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        return new ImmutableSortedShortArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedShortArraySet of(short value1, short value2, short value3, short value4, short value5) {
        MutableShortTreeSet s = new MutableShortTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        s.add(value5);
        return new ImmutableSortedShortArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedShortArraySet of(short ... values) {
        return ImmutableSortedShortArraySet.from(values);
    }

    @NotNull
    public static ImmutableSortedShortArraySet from(short @NotNull [] values) {
        if (values.length == 0) {
            return ImmutableSortedShortArraySet.empty();
        }
        MutableShortTreeSet s = new MutableShortTreeSet();
        s.addAll(values);
        return new ImmutableSortedShortArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedShortArraySet from(@NotNull ShortTraversable values) {
        return ImmutableSortedShortArraySet.from(values.iterator());
    }

    @NotNull
    public static ImmutableSortedShortArraySet from(@NotNull ShortIterator it) {
        if (!it.hasNext()) {
            return ImmutableSortedShortArraySet.empty();
        }
        MutableShortTreeSet s = new MutableShortTreeSet();
        while (it.hasNext()) {
            s.add(it.nextShort());
        }
        return new ImmutableSortedShortArraySet(s.toArray());
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableSortedShortArraySet";
    }

    @NotNull
    public ShortCollectionFactory<?, ImmutableSortedShortArraySet> iterableFactory() {
        return FACTORY;
    }

    @NotNull
    public ShortIterator iterator() {
        return ShortArrays.iterator((short[])this.elements);
    }

    public int size() {
        return this.elements.length;
    }

    public int knownSize() {
        return this.size();
    }

    @Override
    @NotNull
    public ImmutableSortedShortArraySet added(short value) {
        int size = this.elements.length;
        if (size == 0) {
            return new ImmutableSortedShortArraySet(new short[]{value});
        }
        int idx = Arrays.binarySearch(this.elements, value);
        if (idx >= 0) {
            return this;
        }
        idx = -idx - 1;
        short[] newElements = new short[size + 1];
        if (idx == 0) {
            System.arraycopy(this.elements, 0, newElements, 1, size);
            newElements[0] = value;
            return new ImmutableSortedShortArraySet(newElements);
        }
        if (idx == size) {
            System.arraycopy(this.elements, 0, newElements, 0, size);
            newElements[size] = value;
            return new ImmutableSortedShortArraySet(newElements);
        }
        System.arraycopy(this.elements, 0, newElements, 0, idx);
        System.arraycopy(this.elements, idx, newElements, idx + 1, size - idx);
        newElements[idx] = value;
        return new ImmutableSortedShortArraySet(newElements);
    }

    @Override
    @NotNull
    public ImmutableSortedShortArraySet addedAll(@NotNull ShortTraversable values) {
        ShortIterator it = values.iterator();
        if (!it.hasNext()) {
            return this;
        }
        short[] elements = this.elements;
        if (elements.length == 0) {
            return ImmutableSortedShortArraySet.from(values);
        }
        MutableShortTreeSet builder = new MutableShortTreeSet();
        builder.addAll(elements);
        builder.addAll(values);
        if (builder.size() == elements.length) {
            return this;
        }
        return new ImmutableSortedShortArraySet(builder.toArray());
    }

    @Override
    @NotNull
    public ImmutableSortedShortArraySet addedAll(short @NotNull [] values) {
        int arrayLength = values.length;
        if (arrayLength == 0) {
            return this;
        }
        if (arrayLength == 1) {
            return this.added(values[0]);
        }
        int size = this.elements.length;
        if (size == 0) {
            return ImmutableSortedShortArraySet.from(values);
        }
        MutableShortTreeSet builder = new MutableShortTreeSet();
        builder.addAll(this.elements);
        builder.addAll(values);
        return new ImmutableSortedShortArraySet(builder.toArray());
    }

    public short first() {
        if (this.elements.length == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[0];
    }

    public short last() {
        int size = this.elements.length;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[size - 1];
    }

    @NotNull
    public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return (A)ShortArrays.joinTo((short[])this.elements, buffer, (CharSequence)separator, (CharSequence)prefix, (CharSequence)postfix);
    }

    public void forEach(@NotNull ShortConsumer action) {
        for (short e : this.elements) {
            action.accept(e);
        }
    }

    private static final class Factory
    implements ShortCollectionFactory<MutableShortTreeSet, ImmutableSortedShortArraySet> {
        private Factory() {
        }

        public ImmutableSortedShortArraySet empty() {
            return ImmutableSortedShortArraySet.empty();
        }

        public MutableShortTreeSet newBuilder() {
            return new MutableShortTreeSet();
        }

        public ImmutableSortedShortArraySet build(@NotNull MutableShortTreeSet builder) {
            return builder.isEmpty() ? ImmutableSortedShortArraySet.empty() : new ImmutableSortedShortArraySet(builder.toArray());
        }

        public void addToBuilder(@NotNull MutableShortTreeSet builder, short value) {
            builder.add(value);
        }

        public MutableShortTreeSet mergeBuilder(@NotNull MutableShortTreeSet builder1, @NotNull MutableShortTreeSet builder2) {
            builder1.addAll(builder2);
            return builder1;
        }
    }
}

