/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.Conditions;
import kala.collection.base.primitive.CharArrays;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.factory.primitive.CharCollectionFactory;
import kala.collection.immutable.primitive.ImmutableCharArray;
import kala.collection.mutable.primitive.AbstractMutableCharList;
import kala.collection.mutable.primitive.AbstractMutableCharListFactory;
import kala.collection.mutable.primitive.MutableCharListIterator;
import kala.collection.primitive.AbstractCharSeqIterator;
import kala.collection.primitive.CharSeqLike;
import kala.collection.primitive.IndexedCharSeq;
import kala.function.CharSupplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableCharArrayList
extends AbstractMutableCharList
implements IndexedCharSeq,
Serializable {
    private static final long serialVersionUID = 2545219250020890853L;
    private static final Factory FACTORY = new Factory();
    static final int DEFAULT_CAPACITY = 10;
    static final char[] DEFAULT_EMPTY_ARRAY = new char[0];
    char @NotNull [] elements;
    int size;

    private MutableCharArrayList(char @NotNull [] elements, int size) {
        this.elements = elements;
        this.size = size;
    }

    public MutableCharArrayList() {
        this(DEFAULT_EMPTY_ARRAY, 0);
    }

    public MutableCharArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("illegal initialCapacity: " + initialCapacity);
        }
        this.elements = initialCapacity == 0 ? CharArrays.EMPTY : new char[initialCapacity];
        this.size = 0;
    }

    @NotNull
    public static CharCollectionFactory<?, MutableCharArrayList> factory() {
        return FACTORY;
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableCharArrayList create() {
        return new MutableCharArrayList();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableCharArrayList create(int initialCapacity) {
        return new MutableCharArrayList(initialCapacity);
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableCharArrayList of() {
        return new MutableCharArrayList();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableCharArrayList of(char value1) {
        char[] arr = new char[10];
        arr[0] = value1;
        return new MutableCharArrayList(arr, 1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableCharArrayList of(char value1, char value2) {
        char[] arr = new char[10];
        arr[0] = value1;
        arr[1] = value2;
        return new MutableCharArrayList(arr, 2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableCharArrayList of(char value1, char value2, char value3) {
        char[] arr = new char[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        return new MutableCharArrayList(arr, 3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableCharArrayList of(char value1, char value2, char value3, char value4) {
        char[] arr = new char[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        return new MutableCharArrayList(arr, 4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableCharArrayList of(char value1, char value2, char value3, char value4, char value5) {
        char[] arr = new char[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        arr[4] = value5;
        return new MutableCharArrayList(arr, 5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableCharArrayList of(char ... values) {
        return MutableCharArrayList.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableCharArrayList from(char @NotNull [] values) {
        int length = values.length;
        return length != 0 ? new MutableCharArrayList(Arrays.copyOf(values, Integer.max(10, values.length)), length) : new MutableCharArrayList();
    }

    @NotNull
    public static MutableCharArrayList from(@NotNull CharTraversable values) {
        MutableCharArrayList buffer = new MutableCharArrayList();
        buffer.appendAll(values);
        return buffer;
    }

    @NotNull
    public static MutableCharArrayList from(@NotNull CharIterator it) {
        MutableCharArrayList buffer = new MutableCharArrayList();
        while (it.hasNext()) {
            buffer.append(it.next().charValue());
        }
        return buffer;
    }

    @NotNull
    public static MutableCharArrayList fill(int n, char value) {
        if (n <= 0) {
            return new MutableCharArrayList();
        }
        char[] arr = new char[Integer.max(10, n)];
        if (value != '\u0000') {
            Arrays.fill(arr, 0, n, value);
        }
        return new MutableCharArrayList(arr, n);
    }

    @NotNull
    public static MutableCharArrayList fill(int n, @NotNull CharSupplier supplier) {
        if (n <= 0) {
            return new MutableCharArrayList();
        }
        char[] arr = new char[Integer.max(10, n)];
        for (int i = 0; i < n; ++i) {
            arr[i] = supplier.getAsChar();
        }
        return new MutableCharArrayList(arr, n);
    }

    private void grow() {
        this.grow(this.size + 1);
    }

    private void grow(int minCapacity) {
        char[] newArray = this.growArray(minCapacity);
        if (this.elements.length != 0) {
            System.arraycopy(this.elements, 0, newArray, 0, this.size);
        }
        this.elements = newArray;
    }

    private char[] growArray(int minCapacity) {
        int oldCapacity = this.elements.length;
        if (this.elements == DEFAULT_EMPTY_ARRAY && oldCapacity == 0) {
            return new char[Math.max(10, minCapacity)];
        }
        int newCapacity = Math.max(Math.max(oldCapacity, minCapacity), oldCapacity + (oldCapacity >> 1));
        return new char[newCapacity];
    }

    private void checkInBound(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
    }

    char @NotNull [] getArray() {
        return this.elements;
    }

    private void reduceToSize(int newSize) {
        this.size = newSize;
    }

    public void sizeHint(int s) {
        int len = this.elements.length;
        int size = this.size;
        if (s > 0 && s + size > len) {
            this.grow(size + s);
        }
    }

    @Override
    @NotNull
    public String className() {
        return "MutableCharArrayList";
    }

    @NotNull
    public CharCollectionFactory<?, MutableCharArrayList> iterableFactory() {
        return MutableCharArrayList.factory();
    }

    @Override
    @NotNull
    public CharIterator iterator() {
        return CharArrays.iterator((char[])this.elements, (int)0, (int)this.size);
    }

    @Override
    @NotNull
    public CharIterator iterator(int beginIndex) {
        return CharArrays.iterator((char[])this.elements, (int)beginIndex, (int)this.size);
    }

    @Override
    @NotNull
    public MutableCharListIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size);
        return new SeqItr(this, index);
    }

    public MutableCharArrayList clone() {
        return new MutableCharArrayList(this.elements.length == 0 ? this.elements : (char[])this.elements.clone(), this.size);
    }

    public int size() {
        return this.size;
    }

    @Override
    public char get(int index) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        return this.elements[index];
    }

    @Override
    public void set(int index, char newValue) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        this.elements[index] = newValue;
    }

    @Override
    public void prepend(char value) {
        char[] values = this.elements;
        if (this.size == values.length) {
            values = this.growArray(this.size + 1);
        }
        System.arraycopy(this.elements, 0, values, 1, this.size);
        values[0] = value;
        this.elements = values;
        ++this.size;
    }

    @Override
    public void prependAll(@NotNull CharTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            this.appendThis();
            return;
        }
        int size = this.size;
        if (values instanceof CharSeqLike && ((CharSeqLike)values).supportsFastRandomAccess()) {
            CharSeqLike seq = (CharSeqLike)values;
            int s = seq.size();
            if (s == 0) {
                return;
            }
            char[] arr = this.elements;
            if (arr.length < size + s) {
                arr = this.growArray(size + s);
            }
            System.arraycopy(this.elements, 0, arr, s, size);
            for (int i = 0; i < s; ++i) {
                arr[i] = seq.get(i);
            }
            this.elements = arr;
            this.size += s;
            return;
        }
        char[] cv = values.toArray();
        if (cv.length == 0) {
            return;
        }
        char[] elements = this.elements;
        if (elements.length < size + cv.length) {
            elements = this.growArray(size + cv.length);
        }
        System.arraycopy(this.elements, 0, elements, cv.length, size);
        System.arraycopy(cv, 0, elements, 0, cv.length);
        this.elements = elements;
        this.size += cv.length;
    }

    @Override
    public void append(char value) {
        if (this.size == this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = value;
    }

    @Override
    public void appendAll(@NotNull CharTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            this.appendThis();
            return;
        }
        int knowSize = values.knownSize();
        if (knowSize > 0 && this.size + knowSize > this.elements.length) {
            this.grow(this.size + knowSize);
        }
        values.forEach(this::append);
    }

    private void appendThis() {
        int size = this.size;
        if (size == 0) {
            return;
        }
        if (size > 0x3FFFFFFF) {
            throw new OutOfMemoryError("Requested array size exceeds VM limit");
        }
        int newSize = size * 2;
        if (this.elements.length < newSize) {
            this.grow(newSize);
        }
        char[] elements = this.elements;
        System.arraycopy(elements, 0, elements, size, size);
        this.size = newSize;
    }

    @Override
    public int binarySearch(int beginIndex, int endIndex, char value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value);
    }

    @Override
    public void sort() {
        CharArrays.sort((char[])this.elements, (int)0, (int)this.size);
    }

    @Override
    public void insert(int index, char value) {
        int size = this.size;
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException();
        }
        if (index == size) {
            this.append(value);
            return;
        }
        if (this.elements.length == size) {
            this.grow();
        }
        System.arraycopy(this.elements, index, this.elements, index + 1, size - index);
        this.elements[index] = value;
        ++this.size;
    }

    @Override
    public void insertAll(int index, @NotNull CharTraversable values) {
        Objects.requireNonNull(values);
        Conditions.checkPositionIndex((int)index, (int)this.size);
        int otherSize = values.size();
        char[] elements = this.elements;
        if (elements.length < this.size + otherSize || values == this) {
            elements = this.growArray(this.size + otherSize);
        }
        System.arraycopy(this.elements, 0, elements, 0, index);
        System.arraycopy(this.elements, index, elements, index + otherSize, this.size - index);
        CharIterator it = values.iterator();
        for (int i = 0; i < otherSize; ++i) {
            elements[i + index] = it.nextChar();
        }
        assert (!it.hasNext());
        this.elements = elements;
        this.size += otherSize;
    }

    @Override
    public void insertAll(int index, char @NotNull [] values) {
        Objects.requireNonNull(values);
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        if (values.length == 0) {
            return;
        }
        char[] elements = this.elements;
        if (elements.length < this.size + values.length) {
            elements = this.growArray(this.size + values.length);
        }
        System.arraycopy(this.elements, 0, elements, 0, index);
        System.arraycopy(values, 0, elements, index, values.length);
        System.arraycopy(this.elements, index, elements, index + values.length, this.size - index);
        this.elements = elements;
        this.size += values.length;
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            this.elements = this.size == 0 ? DEFAULT_EMPTY_ARRAY : Arrays.copyOf(this.elements, this.size);
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public char removeAt(int index) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        char oldValue = this.elements[index];
        int newSize = this.size - 1;
        if (newSize > index) {
            System.arraycopy(this.elements, index + 1, this.elements, index, newSize - index);
        }
        this.elements[newSize] = '\u0000';
        this.size = newSize;
        return oldValue;
    }

    @Override
    public void removeInRange(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int rangeLength = endIndex - beginIndex;
        if (rangeLength == 0) {
            return;
        }
        if (rangeLength == size) {
            this.clear();
            return;
        }
        if (rangeLength == 1) {
            this.removeAt(beginIndex);
            return;
        }
        int tailElementsCount = size - endIndex;
        System.arraycopy(this.elements, endIndex, this.elements, beginIndex, tailElementsCount);
        this.size = size - rangeLength;
    }

    @Override
    public void dropInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return;
        }
        if (n >= this.size) {
            this.clear();
            return;
        }
        int newSize = this.size - n;
        System.arraycopy(this.elements, n, this.elements, 0, newSize);
        this.reduceToSize(newSize);
    }

    @Override
    public void takeInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.clear();
            return;
        }
        if (n >= this.size) {
            return;
        }
        this.size = n;
    }

    public int copyToArray(int srcPos, char @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + destPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        int destLength = dest.length;
        int size = this.size();
        if (destPos >= destLength || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, destLength - destPos), limit);
        System.arraycopy(this.elements, srcPos, dest, destPos, n);
        return n;
    }

    public char @NotNull [] toArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    @Override
    @NotNull
    public ImmutableCharArray toImmutableArray() {
        return this.size == 0 ? ImmutableCharArray.empty() : ImmutableCharArray.Unsafe.wrap(Arrays.copyOf(this.elements, this.size));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeChar(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        char[] elements = size == 0 ? DEFAULT_EMPTY_ARRAY : new char[Integer.max(10, size)];
        for (int i = 0; i < size; ++i) {
            elements[i] = in.readChar();
        }
        this.size = size;
        this.elements = elements;
    }

    private static final class Factory
    extends AbstractMutableCharListFactory<MutableCharArrayList> {
        private Factory() {
        }

        public MutableCharArrayList newBuilder() {
            return new MutableCharArrayList();
        }

        public void sizeHint(@NotNull MutableCharArrayList buffer, int size) {
            buffer.sizeHint(size);
        }

        public MutableCharArrayList from(char @NotNull [] values) {
            return MutableCharArrayList.from(values);
        }

        public MutableCharArrayList from(@NotNull CharTraversable values) {
            return MutableCharArrayList.from(values);
        }

        public MutableCharArrayList from(@NotNull CharIterator it) {
            return MutableCharArrayList.from(it);
        }

        public MutableCharArrayList fill(int n, char value) {
            return MutableCharArrayList.fill(n, value);
        }

        public MutableCharArrayList fill(int n, @NotNull CharSupplier supplier) {
            return MutableCharArrayList.fill(n, supplier);
        }
    }

    private static final class SeqItr
    extends AbstractCharSeqIterator
    implements MutableCharListIterator {
        private final MutableCharArrayList seq;
        private int lastReturned = -1;

        SeqItr(MutableCharArrayList seq, int index) {
            super(index);
            this.seq = seq;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.seq.size;
        }

        @Override
        public char nextChar() {
            int idx = this.cursor;
            if (idx >= this.seq.size) {
                throw new NoSuchElementException();
            }
            try {
                char res = this.seq.elements[idx];
                this.lastReturned = idx;
                this.cursor = idx + 1;
                return res;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        public char previousChar() {
            int idx = this.cursor - 1;
            if (idx < 0) {
                throw new NoSuchElementException();
            }
            try {
                char res = this.seq.elements[idx];
                this.lastReturned = idx;
                this.cursor = idx;
                return res;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        public void set(char e) {
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            try {
                this.seq.set(this.lastReturned, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(ex);
            }
        }

        @Override
        public void add(char e) {
            int idx = this.cursor;
            try {
                this.seq.insert(idx, e);
                this.cursor = idx + 1;
                this.lastReturned = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(ex);
            }
        }

        @Override
        public void remove() {
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            try {
                this.seq.removeAt(this.lastReturned);
                this.cursor = this.lastReturned;
                this.lastReturned = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(String.format("lastReturned=%d,size=%d,array=%s", this.lastReturned, this.seq.size, Arrays.toString(this.seq.elements)), ex);
            }
        }
    }
}

