/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.DoublePredicate;
import kala.Conditions;
import kala.collection.base.primitive.DoubleGrowable;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.factory.primitive.DoubleCollectionFactory;
import kala.collection.mutable.primitive.MutableDoubleArrayList;
import kala.collection.mutable.primitive.MutableDoubleListIterator;
import kala.collection.mutable.primitive.MutableDoubleSeq;
import kala.collection.mutable.primitive.MutablePrimitiveList;
import kala.collection.primitive.DoubleArraySeq;
import kala.collection.primitive.DoubleSeq;
import kala.collection.primitive.internal.DoubleSeqIterators;
import kala.control.primitive.DoubleOption;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MutableDoubleList
extends MutablePrimitiveList<Double>,
MutableDoubleSeq,
DoubleGrowable {
    @NotNull
    public static DoubleCollectionFactory<?, MutableDoubleList> factory() {
        return DoubleCollectionFactory.narrow(MutableDoubleArrayList.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableDoubleList create() {
        return MutableDoubleArrayList.create();
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableDoubleList of() {
        return MutableDoubleArrayList.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableDoubleList of(double value1) {
        return MutableDoubleArrayList.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableDoubleList of(double value1, double value2) {
        return MutableDoubleArrayList.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableDoubleList of(double value1, double value2, double value3) {
        return MutableDoubleArrayList.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableDoubleList of(double value1, double value2, double value3, double value4) {
        return MutableDoubleArrayList.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableDoubleList of(double value1, double value2, double value3, double value4, double value5) {
        return MutableDoubleArrayList.of(value1, value2, value3, value4, value5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableDoubleList of(double ... values) {
        return MutableDoubleArrayList.of(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableDoubleList from(double @NotNull [] values) {
        return MutableDoubleArrayList.from(values);
    }

    @NotNull
    public static MutableDoubleList from(@NotNull DoubleTraversable values) {
        return MutableDoubleArrayList.from(values);
    }

    @NotNull
    public static MutableDoubleList from(@NotNull DoubleIterator it) {
        return MutableDoubleArrayList.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableDoubleList";
    }

    @NotNull
    default public DoubleCollectionFactory<?, ? extends MutableDoubleList> iterableFactory() {
        return MutableDoubleList.factory();
    }

    @Override
    @NotNull
    default public MutableDoubleListIterator seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableDoubleListIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new DoubleSeqIterators.DefaultMutableDoubleListIterator<MutableDoubleList>(this, index);
    }

    @Contract(mutates="this")
    public void append(@Flow(targetIsContainer=true) double var1);

    @Contract(mutates="this")
    default public void appendAll(@Flow(sourceIsContainer=true, targetIsContainer=true) double @NotNull [] values) {
        int length = values.length;
        if (length != 0) {
            if (length == 1) {
                this.append(values[0]);
            } else {
                this.appendAll(DoubleArraySeq.wrap(values));
            }
        }
    }

    @Contract(mutates="this")
    default public void appendAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) DoubleTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            for (double e : this.toArray()) {
                this.append(e);
            }
        } else {
            values.forEach(this::append);
        }
    }

    default public void plusAssign(double value) {
        this.append(value);
    }

    default public void plusAssign(double @NotNull [] values) {
        this.appendAll(values);
    }

    default public void plusAssign(@NotNull DoubleTraversable values) {
        this.appendAll(values);
    }

    @Contract(mutates="this")
    public void prepend(double var1);

    @Contract(mutates="this")
    default public void prependAll(@Flow(sourceIsContainer=true, targetIsContainer=true) double @NotNull [] values) {
        this.prependAll(DoubleArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public void prependAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) DoubleTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            double[] arr = values.toArray();
            for (int i = arr.length - 1; i >= 0; --i) {
                this.prepend(arr[i]);
            }
            return;
        }
        if (values instanceof DoubleSeq && ((DoubleSeq)values).supportsFastRandomAccess()) {
            DoubleSeq seq = (DoubleSeq)values;
            int s = seq.size();
            for (int i = s - 1; i >= 0; --i) {
                this.prepend(seq.get(i));
            }
            return;
        }
        double[] cv = values.toArray();
        for (int i = cv.length - 1; i >= 0; --i) {
            this.prepend(cv[i]);
        }
    }

    @Contract(mutates="this")
    public void insert(int var1, @Flow(targetIsContainer=true) double var2);

    @Contract(mutates="this")
    default public void insertAll(int index, @Flow(sourceIsContainer=true, targetIsContainer=true) double @NotNull [] values) {
        this.insertAll(index, DoubleArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public void insertAll(int index, @NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) DoubleTraversable values) {
        double[] valuesArray;
        Objects.requireNonNull(values);
        if (this.isEmpty() && index != 0) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        for (double e : valuesArray = values.toArray()) {
            this.insert(index++, e);
        }
    }

    @Contract(mutates="this")
    @Flow(sourceIsContainer=true)
    public double removeAt(int var1);

    default public void removeInRange(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int rangeLength = endIndex - beginIndex;
        if (rangeLength == 0) {
            return;
        }
        if (rangeLength == size) {
            this.clear();
            return;
        }
        for (int i = 0; i < rangeLength; ++i) {
            this.removeAt(beginIndex);
        }
    }

    @Contract(mutates="this")
    default public double removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(0);
    }

    @Contract(mutates="this")
    @Nullable
    default public Double removeFirstOrNull() {
        return this.isEmpty() ? null : Double.valueOf(this.removeAt(0));
    }

    @Contract(mutates="this")
    @NotNull
    default public DoubleOption removeFirstOption() {
        return this.isEmpty() ? DoubleOption.none() : DoubleOption.some((double)this.removeAt(0));
    }

    @Contract(mutates="this")
    default public double removeLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(size - 1);
    }

    @Contract(mutates="this")
    @Nullable
    default public double removeLastOrNull() {
        int size = this.size();
        return size == 0 ? null : Double.valueOf(this.removeAt(size - 1));
    }

    @Contract(mutates="this")
    @NotNull
    default public DoubleOption removeLastOption() {
        int size = this.size();
        return size == 0 ? DoubleOption.none() : DoubleOption.some((double)this.removeAt(size - 1));
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull DoublePredicate predicate) {
        MutableDoubleListIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            double value = it.nextDouble();
            if (!predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull DoublePredicate predicate) {
        MutableDoubleListIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            double value = it.nextDouble();
            if (predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Contract(mutates="this")
    public void clear();

    @Contract(mutates="this")
    default public void dropInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return;
        }
        MutableDoubleListIterator it = this.seqIterator();
        for (int i = 0; i < n && it.hasNext(); ++i) {
            it.nextDouble();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void takeInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.clear();
            return;
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0 && n >= knownSize) {
            return;
        }
        MutableDoubleListIterator it = this.seqIterator(n);
        while (it.hasNext()) {
            it.nextDouble();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull DoublePredicate predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull DoublePredicate predicate) {
        this.removeAll(predicate);
    }
}

