/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.DoubleUnaryOperator;
import kala.Conditions;
import kala.collection.base.primitive.DoubleArrays;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.factory.primitive.DoubleCollectionFactory;
import kala.collection.mutable.primitive.MutableDoubleArray;
import kala.collection.mutable.primitive.MutableDoubleCollection;
import kala.collection.mutable.primitive.MutableDoubleSeqIterator;
import kala.collection.mutable.primitive.MutablePrimitiveSeq;
import kala.collection.primitive.DoubleSeq;
import kala.collection.primitive.internal.DoubleSeqIterators;
import kala.function.IndexedDoubleUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableDoubleSeq
extends MutablePrimitiveSeq<Double>,
DoubleSeq,
MutableDoubleCollection {
    @NotNull
    public static DoubleCollectionFactory<?, MutableDoubleSeq> factory() {
        return DoubleCollectionFactory.narrow(MutableDoubleArray.factory());
    }

    @NotNull
    public static MutableDoubleSeq of() {
        return MutableDoubleArray.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableDoubleSeq of(double value1) {
        return MutableDoubleArray.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableDoubleSeq of(double value1, double value2) {
        return MutableDoubleArray.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableDoubleSeq of(double value1, double value2, double value3) {
        return MutableDoubleArray.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableDoubleSeq of(double value1, double value2, double value3, double value4) {
        return MutableDoubleArray.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableDoubleSeq of(double value1, double value2, double value3, double value4, double value5) {
        return MutableDoubleArray.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static MutableDoubleSeq of(double ... values) {
        return MutableDoubleArray.of(values);
    }

    @NotNull
    public static MutableDoubleSeq from(double @NotNull [] values) {
        return MutableDoubleArray.from(values);
    }

    @NotNull
    public static MutableDoubleSeq from(@NotNull DoubleTraversable values) {
        return MutableDoubleArray.from(values);
    }

    @NotNull
    public static MutableDoubleSeq from(@NotNull DoubleIterator it) {
        return MutableDoubleArray.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableDoubleSeq";
    }

    @NotNull
    default public DoubleCollectionFactory<?, ? extends MutableDoubleSeq> iterableFactory() {
        return MutableDoubleSeq.factory();
    }

    @Override
    @NotNull
    default public MutableDoubleSeqIterator seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableDoubleSeqIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new DoubleSeqIterators.DefaultMutableDoubleSeqIterator<MutableDoubleSeq>(this, index);
    }

    @Contract(mutates="this")
    public void set(int var1, double var2);

    default public void swap(int index1, int index2) {
        double old1 = this.get(index1);
        double old2 = this.get(index2);
        this.set(index1, old2);
        this.set(index2, old1);
    }

    @Contract(mutates="this")
    default public void replaceAll(@NotNull DoubleUnaryOperator operator) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.set(i, operator.applyAsDouble(this.get(i)));
        }
    }

    @Contract(mutates="this")
    default public void replaceAllIndexed(@NotNull IndexedDoubleUnaryOperator operator) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.set(i, operator.applyAsDouble(i, this.get(i)));
        }
    }

    @Contract(mutates="this")
    default public void sort() {
        double[] values = this.toArray();
        Arrays.sort(values);
        for (int i = 0; i < values.length; ++i) {
            this.set(i, values[i]);
        }
    }

    @Contract(mutates="this")
    default public void reverse() {
        int size = this.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size / 2; ++i) {
            this.swap(i, size - i - 1);
        }
    }

    default public void shuffle() {
        this.shuffle(ThreadLocalRandom.current());
    }

    default public void shuffle(@NotNull Random random) {
        int ks = this.knownSize();
        if (ks == 0 || ks == 1) {
            return;
        }
        if (this.supportsFastRandomAccess() || ks > 0 && ks <= 5) {
            if (!1.$assertionsDisabled && ks <= 0) {
                throw new AssertionError();
            }
            for (int i2 = ks; i2 > 1; --i2) {
                this.swap(i2 - 1, random.nextInt(i2));
            }
        } else {
            double[] arr = this.toArray();
            DoubleArrays.shuffle((double[])arr, (Random)random);
            this.replaceAllIndexed((i, v) -> arr[i]);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

