/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import kala.collection.base.primitive.FloatArrays;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.collection.factory.primitive.FloatCollectionFactory;
import kala.collection.mutable.primitive.MutableFloatArrayList;
import kala.collection.mutable.primitive.MutableFloatSeq;
import kala.collection.primitive.FloatArraySeq;
import kala.function.FloatSupplier;
import kala.function.FloatUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableFloatArray
extends FloatArraySeq
implements MutableFloatSeq,
Serializable {
    private static final long serialVersionUID = 8060307722127719792L;
    public static final MutableFloatArray EMPTY = new MutableFloatArray(FloatArrays.EMPTY);
    private static final Factory FACTORY = new Factory();

    MutableFloatArray(float @NotNull [] array) {
        super(array);
    }

    @NotNull
    public static FloatCollectionFactory<?, MutableFloatArray> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableFloatArray create(int size) {
        return new MutableFloatArray(new float[size]);
    }

    @NotNull
    public static MutableFloatArray empty() {
        return EMPTY;
    }

    @NotNull
    public static MutableFloatArray of() {
        return EMPTY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableFloatArray of(float value1) {
        return new MutableFloatArray(new float[]{value1});
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableFloatArray of(float value1, float value2) {
        return new MutableFloatArray(new float[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableFloatArray of(float value1, float value2, float value3) {
        return new MutableFloatArray(new float[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableFloatArray of(float value1, float value2, float value3, float value4) {
        return new MutableFloatArray(new float[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableFloatArray of(float value1, float value2, float value3, float value4, float value5) {
        return new MutableFloatArray(new float[]{value1, value2, value3, value4, value5});
    }

    @NotNull
    public static MutableFloatArray of(float ... values) {
        return values.length != 0 ? new MutableFloatArray(values) : MutableFloatArray.empty();
    }

    @NotNull
    public static MutableFloatArray from(float @NotNull [] values) {
        return values.length != 0 ? new MutableFloatArray((float[])values.clone()) : MutableFloatArray.empty();
    }

    @NotNull
    public static MutableFloatArray from(@NotNull FloatTraversable values) {
        return values.isNotEmpty() ? new MutableFloatArray(values.toArray()) : MutableFloatArray.empty();
    }

    @NotNull
    public static MutableFloatArray from(@NotNull FloatIterator it) {
        if (!it.hasNext()) {
            return MutableFloatArray.empty();
        }
        return new MutableFloatArray(it.toArray());
    }

    @NotNull
    public static MutableFloatArray fill(int n, float value) {
        if (n <= 0) {
            return MutableFloatArray.empty();
        }
        float[] ans = new float[n];
        if (value != 0.0f) {
            Arrays.fill(ans, value);
        }
        return new MutableFloatArray(ans);
    }

    @NotNull
    public static MutableFloatArray fill(int n, @NotNull FloatSupplier supplier) {
        if (n <= 0) {
            return MutableFloatArray.empty();
        }
        float[] ans = new float[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsFloat();
        }
        return new MutableFloatArray(ans);
    }

    @NotNull
    public static MutableFloatArray wrap(float @NotNull [] array) {
        Objects.requireNonNull(array);
        return new MutableFloatArray(array);
    }

    @Override
    @NotNull
    public final String className() {
        return "MutableArray";
    }

    @NotNull
    public FloatCollectionFactory<?, MutableFloatArray> iterableFactory() {
        return MutableFloatArray.factory();
    }

    @NotNull
    public MutableFloatArray clone() {
        return new MutableFloatArray((float[])this.elements.clone());
    }

    public float @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    public void set(int index, float newValue) {
        try {
            this.elements[index] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public void replaceAll(@NotNull FloatUnaryOperator operator) {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = operator.applyAsFloat(this.elements[i]);
        }
    }

    @Override
    public void sort() {
        FloatArrays.sort((float[])this.elements);
    }

    private static final class Factory
    implements FloatCollectionFactory<MutableFloatArrayList, MutableFloatArray> {
        Factory() {
        }

        public MutableFloatArray from(float @NotNull [] values) {
            return MutableFloatArray.from(values);
        }

        public MutableFloatArray from(@NotNull FloatTraversable values) {
            return MutableFloatArray.from(values);
        }

        @NotNull
        public MutableFloatArray from(@NotNull FloatIterator it) {
            return MutableFloatArray.from(it);
        }

        public MutableFloatArray fill(int n, float value) {
            return MutableFloatArray.fill(n, value);
        }

        public MutableFloatArray fill(int n, @NotNull FloatSupplier supplier) {
            return MutableFloatArray.fill(n, supplier);
        }

        public MutableFloatArrayList newBuilder() {
            return new MutableFloatArrayList();
        }

        public void addToBuilder(@NotNull MutableFloatArrayList builder, float value) {
            builder.append(value);
        }

        public void sizeHint(@NotNull MutableFloatArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public MutableFloatArrayList mergeBuilder(@NotNull MutableFloatArrayList builder1, @NotNull MutableFloatArrayList builder2) {
            builder1.appendAll(builder2);
            return builder1;
        }

        public MutableFloatArray build(@NotNull MutableFloatArrayList builder) {
            return new MutableFloatArray(builder.toArray());
        }
    }
}

