/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.NoSuchElementException;
import java.util.Objects;
import kala.Conditions;
import kala.collection.base.primitive.FloatGrowable;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.collection.factory.primitive.FloatCollectionFactory;
import kala.collection.mutable.primitive.MutableFloatArrayList;
import kala.collection.mutable.primitive.MutableFloatListIterator;
import kala.collection.mutable.primitive.MutableFloatSeq;
import kala.collection.mutable.primitive.MutablePrimitiveList;
import kala.collection.primitive.FloatArraySeq;
import kala.collection.primitive.FloatSeq;
import kala.collection.primitive.internal.FloatSeqIterators;
import kala.control.primitive.FloatOption;
import kala.function.FloatPredicate;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MutableFloatList
extends MutablePrimitiveList<Float>,
MutableFloatSeq,
FloatGrowable {
    @NotNull
    public static FloatCollectionFactory<?, MutableFloatList> factory() {
        return FloatCollectionFactory.narrow(MutableFloatArrayList.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableFloatList create() {
        return MutableFloatArrayList.create();
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableFloatList of() {
        return MutableFloatArrayList.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableFloatList of(float value1) {
        return MutableFloatArrayList.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableFloatList of(float value1, float value2) {
        return MutableFloatArrayList.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableFloatList of(float value1, float value2, float value3) {
        return MutableFloatArrayList.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableFloatList of(float value1, float value2, float value3, float value4) {
        return MutableFloatArrayList.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableFloatList of(float value1, float value2, float value3, float value4, float value5) {
        return MutableFloatArrayList.of(value1, value2, value3, value4, value5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableFloatList of(float ... values) {
        return MutableFloatArrayList.of(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableFloatList from(float @NotNull [] values) {
        return MutableFloatArrayList.from(values);
    }

    @NotNull
    public static MutableFloatList from(@NotNull FloatTraversable values) {
        return MutableFloatArrayList.from(values);
    }

    @NotNull
    public static MutableFloatList from(@NotNull FloatIterator it) {
        return MutableFloatArrayList.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableFloatList";
    }

    @NotNull
    default public FloatCollectionFactory<?, ? extends MutableFloatList> iterableFactory() {
        return MutableFloatList.factory();
    }

    @Override
    @NotNull
    default public MutableFloatListIterator seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableFloatListIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new FloatSeqIterators.DefaultMutableFloatListIterator<MutableFloatList>(this, index);
    }

    @Contract(mutates="this")
    public void append(@Flow(targetIsContainer=true) float var1);

    @Contract(mutates="this")
    default public void appendAll(@Flow(sourceIsContainer=true, targetIsContainer=true) float @NotNull [] values) {
        int length = values.length;
        if (length != 0) {
            if (length == 1) {
                this.append(values[0]);
            } else {
                this.appendAll(FloatArraySeq.wrap(values));
            }
        }
    }

    @Contract(mutates="this")
    default public void appendAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) FloatTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            for (float e : this.toArray()) {
                this.append(e);
            }
        } else {
            values.forEach(this::append);
        }
    }

    default public void plusAssign(float value) {
        this.append(value);
    }

    default public void plusAssign(float @NotNull [] values) {
        this.appendAll(values);
    }

    default public void plusAssign(@NotNull FloatTraversable values) {
        this.appendAll(values);
    }

    @Contract(mutates="this")
    public void prepend(float var1);

    @Contract(mutates="this")
    default public void prependAll(@Flow(sourceIsContainer=true, targetIsContainer=true) float @NotNull [] values) {
        this.prependAll(FloatArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public void prependAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) FloatTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            float[] arr = values.toArray();
            for (int i = arr.length - 1; i >= 0; --i) {
                this.prepend(arr[i]);
            }
            return;
        }
        if (values instanceof FloatSeq && ((FloatSeq)values).supportsFastRandomAccess()) {
            FloatSeq seq = (FloatSeq)values;
            int s = seq.size();
            for (int i = s - 1; i >= 0; --i) {
                this.prepend(seq.get(i));
            }
            return;
        }
        float[] cv = values.toArray();
        for (int i = cv.length - 1; i >= 0; --i) {
            this.prepend(cv[i]);
        }
    }

    @Contract(mutates="this")
    public void insert(int var1, @Flow(targetIsContainer=true) float var2);

    @Contract(mutates="this")
    default public void insertAll(int index, @Flow(sourceIsContainer=true, targetIsContainer=true) float @NotNull [] values) {
        this.insertAll(index, FloatArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public void insertAll(int index, @NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) FloatTraversable values) {
        float[] valuesArray;
        Objects.requireNonNull(values);
        if (this.isEmpty() && index != 0) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        for (float e : valuesArray = values.toArray()) {
            this.insert(index++, e);
        }
    }

    @Contract(mutates="this")
    @Flow(sourceIsContainer=true)
    public float removeAt(int var1);

    default public void removeInRange(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int rangeLength = endIndex - beginIndex;
        if (rangeLength == 0) {
            return;
        }
        if (rangeLength == size) {
            this.clear();
            return;
        }
        for (int i = 0; i < rangeLength; ++i) {
            this.removeAt(beginIndex);
        }
    }

    @Contract(mutates="this")
    default public float removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(0);
    }

    @Contract(mutates="this")
    @Nullable
    default public Float removeFirstOrNull() {
        return this.isEmpty() ? null : Float.valueOf(this.removeAt(0));
    }

    @Contract(mutates="this")
    @NotNull
    default public FloatOption removeFirstOption() {
        return this.isEmpty() ? FloatOption.none() : FloatOption.some((float)this.removeAt(0));
    }

    @Contract(mutates="this")
    default public float removeLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(size - 1);
    }

    @Contract(mutates="this")
    @Nullable
    default public float removeLastOrNull() {
        int size = this.size();
        return (size == 0 ? null : Float.valueOf(this.removeAt(size - 1))).floatValue();
    }

    @Contract(mutates="this")
    @NotNull
    default public FloatOption removeLastOption() {
        int size = this.size();
        return size == 0 ? FloatOption.none() : FloatOption.some((float)this.removeAt(size - 1));
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull FloatPredicate predicate) {
        MutableFloatListIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            float value = it.nextFloat();
            if (!predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull FloatPredicate predicate) {
        MutableFloatListIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            float value = it.nextFloat();
            if (predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Contract(mutates="this")
    public void clear();

    @Contract(mutates="this")
    default public void dropInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return;
        }
        MutableFloatListIterator it = this.seqIterator();
        for (int i = 0; i < n && it.hasNext(); ++i) {
            it.nextFloat();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void takeInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.clear();
            return;
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0 && n >= knownSize) {
            return;
        }
        MutableFloatListIterator it = this.seqIterator(n);
        while (it.hasNext()) {
            it.nextFloat();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull FloatPredicate predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull FloatPredicate predicate) {
        this.removeAll(predicate);
    }
}

