/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.AnySet;
import kala.collection.base.primitive.AbstractFloatIterator;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.collection.factory.primitive.FloatCollectionFactory;
import kala.collection.mutable.primitive.AbstractMutableFloatSetFactory;
import kala.collection.mutable.primitive.MutableFloatSet;
import kala.collection.primitive.FloatSet;
import kala.collection.primitive.internal.tree.FloatRedBlackTree;
import kala.function.FloatConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableFloatTreeSet
extends FloatRedBlackTree<Node>
implements MutableFloatSet,
Cloneable,
Serializable {
    private static final long serialVersionUID = 6211626172352429615L;
    private static final Factory FACTORY = new Factory();

    @NotNull
    public static FloatCollectionFactory<?, MutableFloatTreeSet> factory() {
        return FACTORY;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static MutableFloatTreeSet create() {
        return new MutableFloatTreeSet();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static MutableFloatTreeSet of() {
        return new MutableFloatTreeSet();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableFloatTreeSet of(float value1) {
        MutableFloatTreeSet s = new MutableFloatTreeSet();
        s.add(value1);
        return s;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static MutableFloatTreeSet of(float value1, float value2) {
        MutableFloatTreeSet s = new MutableFloatTreeSet();
        s.add(value1);
        s.add(value2);
        return s;
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static MutableFloatTreeSet of(float value1, float value2, float value3) {
        MutableFloatTreeSet s = new MutableFloatTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        return s;
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static MutableFloatTreeSet of(float value1, float value2, float value3, float value4) {
        MutableFloatTreeSet s = new MutableFloatTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        return s;
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static MutableFloatTreeSet of(float value1, float value2, float value3, float value4, float value5) {
        MutableFloatTreeSet s = new MutableFloatTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        s.add(value5);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableFloatTreeSet of(float ... values) {
        return MutableFloatTreeSet.from(values);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableFloatTreeSet from(float @NotNull [] values) {
        Objects.requireNonNull(values);
        MutableFloatTreeSet s = new MutableFloatTreeSet();
        s.addAll(values);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableFloatTreeSet from(@NotNull FloatTraversable values) {
        Objects.requireNonNull(values);
        MutableFloatTreeSet s = new MutableFloatTreeSet();
        s.addAll(values);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableFloatTreeSet from(@NotNull FloatIterator it) {
        MutableFloatTreeSet s = new MutableFloatTreeSet();
        while (it.hasNext()) {
            s.add(it.nextFloat());
        }
        return s;
    }

    @Override
    @NotNull
    public String className() {
        return "MutableFloatTreeSet";
    }

    @NotNull
    public FloatCollectionFactory<?, MutableFloatTreeSet> iterableFactory() {
        return FACTORY;
    }

    @NotNull
    public FloatIterator iterator() {
        Node firstNode = (Node)this.firstNode();
        return firstNode == null ? FloatIterator.empty() : new Itr(firstNode);
    }

    @NotNull
    public MutableFloatTreeSet clone() {
        return MutableFloatTreeSet.from(this);
    }

    @Override
    public boolean add(float value) {
        int c;
        Node parent;
        Node node = (Node)this.root;
        if (node == null) {
            this.root = new Node(value, null);
            this.size = 1;
            return true;
        }
        do {
            parent = node;
            c = Float.compare(value, node.getValue());
            if (c < 0) {
                node = (Node)node.left;
                continue;
            }
            if (c > 0) {
                node = (Node)node.right;
                continue;
            }
            return false;
        } while (node != null);
        Node n = new Node(value, parent);
        if (c < 0) {
            parent.left = n;
        } else {
            parent.right = n;
        }
        ++this.size;
        this.fixAfterInsert(n);
        return true;
    }

    @Override
    public boolean remove(float value) {
        Node node = (Node)this.getNode(value);
        if (node == null) {
            return false;
        }
        this.remove0(node);
        return true;
    }

    @Override
    public boolean contains(float value) {
        return this.getNode(value) != null;
    }

    public float first() {
        Node node = (Node)this.firstNode();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    public float last() {
        Node node = (Node)this.lastNode();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    public float @NotNull [] toArray() {
        int size = this.size;
        float[] res = new float[size];
        if (size == 0) {
            return res;
        }
        FloatIterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            res[i] = it.nextFloat();
        }
        return res;
    }

    public int hashCode() {
        return FloatSet.hashCode(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof AnySet && FloatSet.equals(this, (AnySet)obj);
    }

    public void forEach(@NotNull FloatConsumer action) {
        this.forEachKey0(action);
    }

    public String toString() {
        return this.joinToString(", ", "MutableTreeSet[", "]");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            this.add(in.readFloat());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size);
        this.forEachUnchecked(out::writeFloat);
    }

    private static final class Factory
    extends AbstractMutableFloatSetFactory<MutableFloatTreeSet> {
        private Factory() {
        }

        public MutableFloatTreeSet newBuilder() {
            return new MutableFloatTreeSet();
        }
    }

    static final class Node
    extends FloatRedBlackTree.Node<Node> {
        Node(float value, Node parent) {
            super(value, parent);
        }

        void setValue(float newValue) {
            this.key = newValue;
        }

        float getValue() {
            return this.key;
        }

        public String toString() {
            return String.format("MutableFloatTreeSet.Node[value=%s, color=%s, parent=%s, left=%s, right=%s]", Float.valueOf(this.key), this.color ? "RED" : "BLACK", this.parent, this.left, this.right);
        }
    }

    private static final class Itr
    extends AbstractFloatIterator {
        private Node node;

        Itr(Node node) {
            this.node = node;
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public float nextFloat() {
            Node n;
            Node node = this.node;
            if (node == null) {
                throw new NoSuchElementException();
            }
            if (node.right != null) {
                n = (Node)node.right;
                while (n.left != null) {
                    n = (Node)n.left;
                }
            } else {
                n = (Node)node.parent;
                Node c = node;
                while (n != null && c == n.right) {
                    c = n;
                    n = (Node)n.parent;
                }
            }
            this.node = n;
            return node.getValue();
        }
    }
}

