/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.LongSupplier;
import kala.Conditions;
import kala.collection.base.primitive.LongArrays;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.collection.factory.primitive.LongCollectionFactory;
import kala.collection.immutable.primitive.ImmutableLongArray;
import kala.collection.mutable.primitive.AbstractMutableLongList;
import kala.collection.mutable.primitive.AbstractMutableLongListFactory;
import kala.collection.mutable.primitive.MutableLongListIterator;
import kala.collection.primitive.AbstractLongSeqIterator;
import kala.collection.primitive.IndexedLongSeq;
import kala.collection.primitive.LongSeqLike;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableLongArrayList
extends AbstractMutableLongList
implements IndexedLongSeq,
Serializable {
    private static final long serialVersionUID = 2545219250020890853L;
    private static final Factory FACTORY = new Factory();
    static final int DEFAULT_CAPACITY = 10;
    static final long[] DEFAULT_EMPTY_ARRAY = new long[0];
    long @NotNull [] elements;
    int size;

    private MutableLongArrayList(long @NotNull [] elements, int size) {
        this.elements = elements;
        this.size = size;
    }

    public MutableLongArrayList() {
        this(DEFAULT_EMPTY_ARRAY, 0);
    }

    public MutableLongArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("illegal initialCapacity: " + initialCapacity);
        }
        this.elements = initialCapacity == 0 ? LongArrays.EMPTY : new long[initialCapacity];
        this.size = 0;
    }

    @NotNull
    public static LongCollectionFactory<?, MutableLongArrayList> factory() {
        return FACTORY;
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableLongArrayList create() {
        return new MutableLongArrayList();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableLongArrayList create(int initialCapacity) {
        return new MutableLongArrayList(initialCapacity);
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableLongArrayList of() {
        return new MutableLongArrayList();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableLongArrayList of(long value1) {
        long[] arr = new long[10];
        arr[0] = value1;
        return new MutableLongArrayList(arr, 1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableLongArrayList of(long value1, long value2) {
        long[] arr = new long[10];
        arr[0] = value1;
        arr[1] = value2;
        return new MutableLongArrayList(arr, 2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableLongArrayList of(long value1, long value2, long value3) {
        long[] arr = new long[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        return new MutableLongArrayList(arr, 3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableLongArrayList of(long value1, long value2, long value3, long value4) {
        long[] arr = new long[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        return new MutableLongArrayList(arr, 4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableLongArrayList of(long value1, long value2, long value3, long value4, long value5) {
        long[] arr = new long[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        arr[4] = value5;
        return new MutableLongArrayList(arr, 5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableLongArrayList of(long ... values) {
        return MutableLongArrayList.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableLongArrayList from(long @NotNull [] values) {
        int length = values.length;
        return length != 0 ? new MutableLongArrayList(Arrays.copyOf(values, Integer.max(10, values.length)), length) : new MutableLongArrayList();
    }

    @NotNull
    public static MutableLongArrayList from(@NotNull LongTraversable values) {
        MutableLongArrayList buffer = new MutableLongArrayList();
        buffer.appendAll(values);
        return buffer;
    }

    @NotNull
    public static MutableLongArrayList from(@NotNull LongIterator it) {
        MutableLongArrayList buffer = new MutableLongArrayList();
        while (it.hasNext()) {
            buffer.append(it.next());
        }
        return buffer;
    }

    @NotNull
    public static MutableLongArrayList fill(int n, long value) {
        if (n <= 0) {
            return new MutableLongArrayList();
        }
        long[] arr = new long[Integer.max(10, n)];
        if (value != 0L) {
            Arrays.fill(arr, 0, n, value);
        }
        return new MutableLongArrayList(arr, n);
    }

    @NotNull
    public static MutableLongArrayList fill(int n, @NotNull LongSupplier supplier) {
        if (n <= 0) {
            return new MutableLongArrayList();
        }
        long[] arr = new long[Integer.max(10, n)];
        for (int i = 0; i < n; ++i) {
            arr[i] = supplier.getAsLong();
        }
        return new MutableLongArrayList(arr, n);
    }

    private void grow() {
        this.grow(this.size + 1);
    }

    private void grow(int minCapacity) {
        long[] newArray = this.growArray(minCapacity);
        if (this.elements.length != 0) {
            System.arraycopy(this.elements, 0, newArray, 0, this.size);
        }
        this.elements = newArray;
    }

    private long[] growArray(int minCapacity) {
        int oldCapacity = this.elements.length;
        if (this.elements == DEFAULT_EMPTY_ARRAY && oldCapacity == 0) {
            return new long[Math.max(10, minCapacity)];
        }
        int newCapacity = Math.max(Math.max(oldCapacity, minCapacity), oldCapacity + (oldCapacity >> 1));
        return new long[newCapacity];
    }

    private void checkInBound(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
    }

    long @NotNull [] getArray() {
        return this.elements;
    }

    private void reduceToSize(int newSize) {
        this.size = newSize;
    }

    public void sizeHint(int s) {
        int len = this.elements.length;
        int size = this.size;
        if (s > 0 && s + size > len) {
            this.grow(size + s);
        }
    }

    @Override
    @NotNull
    public String className() {
        return "MutableLongArrayList";
    }

    @NotNull
    public LongCollectionFactory<?, MutableLongArrayList> iterableFactory() {
        return MutableLongArrayList.factory();
    }

    @Override
    @NotNull
    public LongIterator iterator() {
        return LongArrays.iterator((long[])this.elements, (int)0, (int)this.size);
    }

    @Override
    @NotNull
    public LongIterator iterator(int beginIndex) {
        return LongArrays.iterator((long[])this.elements, (int)beginIndex, (int)this.size);
    }

    @Override
    @NotNull
    public MutableLongListIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size);
        return new SeqItr(this, index);
    }

    @NotNull
    public Spliterator.OfLong spliterator() {
        return Arrays.spliterator(this.elements, 0, this.size);
    }

    public MutableLongArrayList clone() {
        return new MutableLongArrayList(this.elements.length == 0 ? this.elements : (long[])this.elements.clone(), this.size);
    }

    public int size() {
        return this.size;
    }

    @Override
    public long get(int index) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        return this.elements[index];
    }

    @Override
    public void set(int index, long newValue) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        this.elements[index] = newValue;
    }

    @Override
    public void prepend(long value) {
        long[] values = this.elements;
        if (this.size == values.length) {
            values = this.growArray(this.size + 1);
        }
        System.arraycopy(this.elements, 0, values, 1, this.size);
        values[0] = value;
        this.elements = values;
        ++this.size;
    }

    @Override
    public void prependAll(@NotNull LongTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            this.appendThis();
            return;
        }
        int size = this.size;
        if (values instanceof LongSeqLike && ((LongSeqLike)values).supportsFastRandomAccess()) {
            LongSeqLike seq = (LongSeqLike)values;
            int s = seq.size();
            if (s == 0) {
                return;
            }
            long[] arr = this.elements;
            if (arr.length < size + s) {
                arr = this.growArray(size + s);
            }
            System.arraycopy(this.elements, 0, arr, s, size);
            for (int i = 0; i < s; ++i) {
                arr[i] = seq.get(i);
            }
            this.elements = arr;
            this.size += s;
            return;
        }
        long[] cv = values.toArray();
        if (cv.length == 0) {
            return;
        }
        long[] elements = this.elements;
        if (elements.length < size + cv.length) {
            elements = this.growArray(size + cv.length);
        }
        System.arraycopy(this.elements, 0, elements, cv.length, size);
        System.arraycopy(cv, 0, elements, 0, cv.length);
        this.elements = elements;
        this.size += cv.length;
    }

    @Override
    public void append(long value) {
        if (this.size == this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = value;
    }

    @Override
    public void appendAll(@NotNull LongTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            this.appendThis();
            return;
        }
        int knowSize = values.knownSize();
        if (knowSize > 0 && this.size + knowSize > this.elements.length) {
            this.grow(this.size + knowSize);
        }
        values.forEach(this::append);
    }

    private void appendThis() {
        int size = this.size;
        if (size == 0) {
            return;
        }
        if (size > 0x3FFFFFFF) {
            throw new OutOfMemoryError("Requested array size exceeds VM limit");
        }
        int newSize = size * 2;
        if (this.elements.length < newSize) {
            this.grow(newSize);
        }
        long[] elements = this.elements;
        System.arraycopy(elements, 0, elements, size, size);
        this.size = newSize;
    }

    @Override
    public int binarySearch(int beginIndex, int endIndex, long value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value);
    }

    @Override
    public void sort() {
        LongArrays.sort((long[])this.elements, (int)0, (int)this.size);
    }

    @Override
    public void insert(int index, long value) {
        int size = this.size;
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException();
        }
        if (index == size) {
            this.append(value);
            return;
        }
        if (this.elements.length == size) {
            this.grow();
        }
        System.arraycopy(this.elements, index, this.elements, index + 1, size - index);
        this.elements[index] = value;
        ++this.size;
    }

    @Override
    public void insertAll(int index, @NotNull LongTraversable values) {
        Objects.requireNonNull(values);
        Conditions.checkPositionIndex((int)index, (int)this.size);
        int otherSize = values.size();
        long[] elements = this.elements;
        if (elements.length < this.size + otherSize || values == this) {
            elements = this.growArray(this.size + otherSize);
        }
        System.arraycopy(this.elements, 0, elements, 0, index);
        System.arraycopy(this.elements, index, elements, index + otherSize, this.size - index);
        LongIterator it = values.iterator();
        for (int i = 0; i < otherSize; ++i) {
            elements[i + index] = it.nextLong();
        }
        assert (!it.hasNext());
        this.elements = elements;
        this.size += otherSize;
    }

    @Override
    public void insertAll(int index, long @NotNull [] values) {
        Objects.requireNonNull(values);
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        if (values.length == 0) {
            return;
        }
        long[] elements = this.elements;
        if (elements.length < this.size + values.length) {
            elements = this.growArray(this.size + values.length);
        }
        System.arraycopy(this.elements, 0, elements, 0, index);
        System.arraycopy(values, 0, elements, index, values.length);
        System.arraycopy(this.elements, index, elements, index + values.length, this.size - index);
        this.elements = elements;
        this.size += values.length;
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            this.elements = this.size == 0 ? DEFAULT_EMPTY_ARRAY : Arrays.copyOf(this.elements, this.size);
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public long removeAt(int index) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        long oldValue = this.elements[index];
        int newSize = this.size - 1;
        if (newSize > index) {
            System.arraycopy(this.elements, index + 1, this.elements, index, newSize - index);
        }
        this.elements[newSize] = 0L;
        this.size = newSize;
        return oldValue;
    }

    @Override
    public void removeInRange(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int rangeLength = endIndex - beginIndex;
        if (rangeLength == 0) {
            return;
        }
        if (rangeLength == size) {
            this.clear();
            return;
        }
        if (rangeLength == 1) {
            this.removeAt(beginIndex);
            return;
        }
        int tailElementsCount = size - endIndex;
        System.arraycopy(this.elements, endIndex, this.elements, beginIndex, tailElementsCount);
        this.size = size - rangeLength;
    }

    @Override
    public void dropInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return;
        }
        if (n >= this.size) {
            this.clear();
            return;
        }
        int newSize = this.size - n;
        System.arraycopy(this.elements, n, this.elements, 0, newSize);
        this.reduceToSize(newSize);
    }

    @Override
    public void takeInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.clear();
            return;
        }
        if (n >= this.size) {
            return;
        }
        this.size = n;
    }

    public int copyToArray(int srcPos, long @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + destPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        int destLength = dest.length;
        int size = this.size();
        if (destPos >= destLength || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, destLength - destPos), limit);
        System.arraycopy(this.elements, srcPos, dest, destPos, n);
        return n;
    }

    public long @NotNull [] toArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    @Override
    @NotNull
    public ImmutableLongArray toImmutableArray() {
        return this.size == 0 ? ImmutableLongArray.empty() : ImmutableLongArray.Unsafe.wrap(Arrays.copyOf(this.elements, this.size));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeLong(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        long[] elements = size == 0 ? DEFAULT_EMPTY_ARRAY : new long[Integer.max(10, size)];
        for (int i = 0; i < size; ++i) {
            elements[i] = in.readLong();
        }
        this.size = size;
        this.elements = elements;
    }

    private static final class Factory
    extends AbstractMutableLongListFactory<MutableLongArrayList> {
        private Factory() {
        }

        public MutableLongArrayList newBuilder() {
            return new MutableLongArrayList();
        }

        public void sizeHint(@NotNull MutableLongArrayList buffer, int size) {
            buffer.sizeHint(size);
        }

        public MutableLongArrayList from(long @NotNull [] values) {
            return MutableLongArrayList.from(values);
        }

        public MutableLongArrayList from(@NotNull LongTraversable values) {
            return MutableLongArrayList.from(values);
        }

        public MutableLongArrayList from(@NotNull LongIterator it) {
            return MutableLongArrayList.from(it);
        }

        public MutableLongArrayList fill(int n, long value) {
            return MutableLongArrayList.fill(n, value);
        }

        public MutableLongArrayList fill(int n, @NotNull LongSupplier supplier) {
            return MutableLongArrayList.fill(n, supplier);
        }
    }

    private static final class SeqItr
    extends AbstractLongSeqIterator
    implements MutableLongListIterator {
        private final MutableLongArrayList seq;
        private int lastReturned = -1;

        SeqItr(MutableLongArrayList seq, int index) {
            super(index);
            this.seq = seq;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.seq.size;
        }

        @Override
        public long nextLong() {
            int idx = this.cursor;
            if (idx >= this.seq.size) {
                throw new NoSuchElementException();
            }
            try {
                long res = this.seq.elements[idx];
                this.lastReturned = idx;
                this.cursor = idx + 1;
                return res;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        public long previousLong() {
            int idx = this.cursor - 1;
            if (idx < 0) {
                throw new NoSuchElementException();
            }
            try {
                long res = this.seq.elements[idx];
                this.lastReturned = idx;
                this.cursor = idx;
                return res;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        public void set(long e) {
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            try {
                this.seq.set(this.lastReturned, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(ex);
            }
        }

        @Override
        public void add(long e) {
            int idx = this.cursor;
            try {
                this.seq.insert(idx, e);
                this.cursor = idx + 1;
                this.lastReturned = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(ex);
            }
        }

        @Override
        public void remove() {
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            try {
                this.seq.removeAt(this.lastReturned);
                this.cursor = this.lastReturned;
                this.lastReturned = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(String.format("lastReturned=%d,size=%d,array=%s", this.lastReturned, this.seq.size, Arrays.toString(this.seq.elements)), ex);
            }
        }
    }
}

