/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.Objects;
import java.util.function.LongPredicate;
import kala.collection.base.primitive.LongGrowable;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.collection.factory.primitive.LongCollectionFactory;
import kala.collection.mutable.primitive.MutableLongCollection;
import kala.collection.mutable.primitive.MutableLongTreeSet;
import kala.collection.mutable.primitive.MutablePrimitiveSet;
import kala.collection.primitive.LongArraySeq;
import kala.collection.primitive.LongSet;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableLongSet
extends MutablePrimitiveSet<Long>,
LongSet,
MutableLongCollection,
LongGrowable {
    @Contract(pure=true)
    @NotNull
    public static LongCollectionFactory<?, MutableLongSet> factory() {
        return LongCollectionFactory.narrow(MutableLongTreeSet.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableLongSet create() {
        return MutableLongTreeSet.create();
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableLongSet of() {
        return MutableLongTreeSet.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableLongSet of(long value1) {
        return MutableLongTreeSet.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableLongSet of(long value1, long value2) {
        return MutableLongTreeSet.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableLongSet of(long value1, long value2, long value3) {
        return MutableLongTreeSet.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableLongSet of(long value1, long value2, long value3, long value4) {
        return MutableLongTreeSet.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableLongSet of(long value1, long value2, long value3, long value4, long value5) {
        return MutableLongTreeSet.of(value1, value2, value3, value4, value5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableLongSet of(long ... values) {
        return MutableLongTreeSet.of(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableLongSet from(long @NotNull [] values) {
        return MutableLongTreeSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableLongSet from(@NotNull LongTraversable values) {
        return MutableLongTreeSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableLongSet from(@NotNull LongIterator it) {
        return MutableLongTreeSet.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableLongSet";
    }

    @NotNull
    default public LongCollectionFactory<?, ? extends MutableLongSet> iterableFactory() {
        return MutableLongSet.factory();
    }

    @Contract(mutates="this")
    public boolean add(@Flow(targetIsContainer=true) long var1);

    @Contract(mutates="this")
    default public boolean addAll(@Flow(sourceIsContainer=true, targetIsContainer=true) long @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.addAll(LongArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean addAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) LongTraversable values) {
        if (values == this) {
            return false;
        }
        boolean m = false;
        LongIterator it = values.iterator();
        while (it.hasNext()) {
            if (!this.add(it.nextLong())) continue;
            m = true;
        }
        return m;
    }

    default public void plusAssign(long value) {
        this.add(value);
    }

    default public void plusAssign(long @NotNull [] values) {
        this.addAll(values);
    }

    default public void plusAssign(@NotNull LongTraversable values) {
        this.addAll(values);
    }

    @Contract(mutates="this")
    public void clear();

    @Contract(mutates="this")
    public boolean remove(long var1);

    @Contract(mutates="this")
    default public boolean removeAll(long @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.removeAll(LongArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull LongTraversable values) {
        Objects.requireNonNull(values);
        boolean m = false;
        LongIterator it = values.iterator();
        while (it.hasNext()) {
            if (!this.remove(it.nextLong())) continue;
            m = true;
        }
        return m;
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        long[] arr = this.toArray();
        int oldSize = arr.length;
        for (long e : arr) {
            if (!predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public boolean retainAll(long @NotNull [] values) {
        return this.retainAll(LongArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull LongTraversable values) {
        Objects.requireNonNull(values);
        if (this.isEmpty() || values.isEmpty()) {
            return false;
        }
        long[] arr = this.toArray();
        int oldSize = arr.length;
        LongIterator it = this.iterator();
        while (it.hasNext()) {
            long v = it.nextLong();
            if (values.contains(v)) continue;
            this.remove(v);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        long[] arr = this.toArray();
        int oldSize = arr.length;
        for (long e : arr) {
            if (predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull LongPredicate predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull LongPredicate predicate) {
        this.removeAll(predicate);
    }
}

