/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import kala.collection.base.primitive.ShortArrays;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.collection.factory.primitive.ShortCollectionFactory;
import kala.collection.mutable.primitive.MutableShortArrayList;
import kala.collection.mutable.primitive.MutableShortSeq;
import kala.collection.primitive.ShortArraySeq;
import kala.function.ShortSupplier;
import kala.function.ShortUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableShortArray
extends ShortArraySeq
implements MutableShortSeq,
Serializable {
    private static final long serialVersionUID = 8060307722127719792L;
    public static final MutableShortArray EMPTY = new MutableShortArray(ShortArrays.EMPTY);
    private static final Factory FACTORY = new Factory();

    MutableShortArray(short @NotNull [] array) {
        super(array);
    }

    @NotNull
    public static ShortCollectionFactory<?, MutableShortArray> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableShortArray create(int size) {
        return new MutableShortArray(new short[size]);
    }

    @NotNull
    public static MutableShortArray empty() {
        return EMPTY;
    }

    @NotNull
    public static MutableShortArray of() {
        return EMPTY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableShortArray of(short value1) {
        return new MutableShortArray(new short[]{value1});
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableShortArray of(short value1, short value2) {
        return new MutableShortArray(new short[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableShortArray of(short value1, short value2, short value3) {
        return new MutableShortArray(new short[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableShortArray of(short value1, short value2, short value3, short value4) {
        return new MutableShortArray(new short[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableShortArray of(short value1, short value2, short value3, short value4, short value5) {
        return new MutableShortArray(new short[]{value1, value2, value3, value4, value5});
    }

    @NotNull
    public static MutableShortArray of(short ... values) {
        return values.length != 0 ? new MutableShortArray(values) : MutableShortArray.empty();
    }

    @NotNull
    public static MutableShortArray from(short @NotNull [] values) {
        return values.length != 0 ? new MutableShortArray((short[])values.clone()) : MutableShortArray.empty();
    }

    @NotNull
    public static MutableShortArray from(@NotNull ShortTraversable values) {
        return values.isNotEmpty() ? new MutableShortArray(values.toArray()) : MutableShortArray.empty();
    }

    @NotNull
    public static MutableShortArray from(@NotNull ShortIterator it) {
        if (!it.hasNext()) {
            return MutableShortArray.empty();
        }
        return new MutableShortArray(it.toArray());
    }

    @NotNull
    public static MutableShortArray fill(int n, short value) {
        if (n <= 0) {
            return MutableShortArray.empty();
        }
        short[] ans = new short[n];
        if (value != 0) {
            Arrays.fill(ans, value);
        }
        return new MutableShortArray(ans);
    }

    @NotNull
    public static MutableShortArray fill(int n, @NotNull ShortSupplier supplier) {
        if (n <= 0) {
            return MutableShortArray.empty();
        }
        short[] ans = new short[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsShort();
        }
        return new MutableShortArray(ans);
    }

    @NotNull
    public static MutableShortArray wrap(short @NotNull [] array) {
        Objects.requireNonNull(array);
        return new MutableShortArray(array);
    }

    @Override
    @NotNull
    public final String className() {
        return "MutableArray";
    }

    @NotNull
    public ShortCollectionFactory<?, MutableShortArray> iterableFactory() {
        return MutableShortArray.factory();
    }

    @NotNull
    public MutableShortArray clone() {
        return new MutableShortArray((short[])this.elements.clone());
    }

    public short @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    public void set(int index, short newValue) {
        try {
            this.elements[index] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public void replaceAll(@NotNull ShortUnaryOperator operator) {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = operator.applyAsShort(this.elements[i]);
        }
    }

    @Override
    public void sort() {
        ShortArrays.sort((short[])this.elements);
    }

    private static final class Factory
    implements ShortCollectionFactory<MutableShortArrayList, MutableShortArray> {
        Factory() {
        }

        public MutableShortArray from(short @NotNull [] values) {
            return MutableShortArray.from(values);
        }

        public MutableShortArray from(@NotNull ShortTraversable values) {
            return MutableShortArray.from(values);
        }

        @NotNull
        public MutableShortArray from(@NotNull ShortIterator it) {
            return MutableShortArray.from(it);
        }

        public MutableShortArray fill(int n, short value) {
            return MutableShortArray.fill(n, value);
        }

        public MutableShortArray fill(int n, @NotNull ShortSupplier supplier) {
            return MutableShortArray.fill(n, supplier);
        }

        public MutableShortArrayList newBuilder() {
            return new MutableShortArrayList();
        }

        public void addToBuilder(@NotNull MutableShortArrayList builder, short value) {
            builder.append(value);
        }

        public void sizeHint(@NotNull MutableShortArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public MutableShortArrayList mergeBuilder(@NotNull MutableShortArrayList builder1, @NotNull MutableShortArrayList builder2) {
            builder1.appendAll(builder2);
            return builder1;
        }

        public MutableShortArray build(@NotNull MutableShortArrayList builder) {
            return new MutableShortArray(builder.toArray());
        }
    }
}

