/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.NoSuchElementException;
import java.util.Objects;
import kala.Conditions;
import kala.collection.base.primitive.ShortGrowable;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.collection.factory.primitive.ShortCollectionFactory;
import kala.collection.mutable.primitive.MutablePrimitiveList;
import kala.collection.mutable.primitive.MutableShortArrayList;
import kala.collection.mutable.primitive.MutableShortListIterator;
import kala.collection.mutable.primitive.MutableShortSeq;
import kala.collection.primitive.ShortArraySeq;
import kala.collection.primitive.ShortSeq;
import kala.collection.primitive.internal.ShortSeqIterators;
import kala.control.primitive.ShortOption;
import kala.function.ShortPredicate;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MutableShortList
extends MutablePrimitiveList<Short>,
MutableShortSeq,
ShortGrowable {
    @NotNull
    public static ShortCollectionFactory<?, MutableShortList> factory() {
        return ShortCollectionFactory.narrow(MutableShortArrayList.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableShortList create() {
        return MutableShortArrayList.create();
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableShortList of() {
        return MutableShortArrayList.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableShortList of(short value1) {
        return MutableShortArrayList.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableShortList of(short value1, short value2) {
        return MutableShortArrayList.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableShortList of(short value1, short value2, short value3) {
        return MutableShortArrayList.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableShortList of(short value1, short value2, short value3, short value4) {
        return MutableShortArrayList.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableShortList of(short value1, short value2, short value3, short value4, short value5) {
        return MutableShortArrayList.of(value1, value2, value3, value4, value5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableShortList of(short ... values) {
        return MutableShortArrayList.of(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableShortList from(short @NotNull [] values) {
        return MutableShortArrayList.from(values);
    }

    @NotNull
    public static MutableShortList from(@NotNull ShortTraversable values) {
        return MutableShortArrayList.from(values);
    }

    @NotNull
    public static MutableShortList from(@NotNull ShortIterator it) {
        return MutableShortArrayList.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableShortList";
    }

    @NotNull
    default public ShortCollectionFactory<?, ? extends MutableShortList> iterableFactory() {
        return MutableShortList.factory();
    }

    @Override
    @NotNull
    default public MutableShortListIterator seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableShortListIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new ShortSeqIterators.DefaultMutableShortListIterator<MutableShortList>(this, index);
    }

    @Contract(mutates="this")
    public void append(@Flow(targetIsContainer=true) short var1);

    @Contract(mutates="this")
    default public void appendAll(@Flow(sourceIsContainer=true, targetIsContainer=true) short @NotNull [] values) {
        int length = values.length;
        if (length != 0) {
            if (length == 1) {
                this.append(values[0]);
            } else {
                this.appendAll(ShortArraySeq.wrap(values));
            }
        }
    }

    @Contract(mutates="this")
    default public void appendAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) ShortTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            for (short e : this.toArray()) {
                this.append(e);
            }
        } else {
            values.forEach(this::append);
        }
    }

    default public void plusAssign(short value) {
        this.append(value);
    }

    default public void plusAssign(short @NotNull [] values) {
        this.appendAll(values);
    }

    default public void plusAssign(@NotNull ShortTraversable values) {
        this.appendAll(values);
    }

    @Contract(mutates="this")
    public void prepend(short var1);

    @Contract(mutates="this")
    default public void prependAll(@Flow(sourceIsContainer=true, targetIsContainer=true) short @NotNull [] values) {
        this.prependAll(ShortArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public void prependAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) ShortTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            short[] arr = values.toArray();
            for (int i = arr.length - 1; i >= 0; --i) {
                this.prepend(arr[i]);
            }
            return;
        }
        if (values instanceof ShortSeq && ((ShortSeq)values).supportsFastRandomAccess()) {
            ShortSeq seq = (ShortSeq)values;
            int s = seq.size();
            for (int i = s - 1; i >= 0; --i) {
                this.prepend(seq.get(i));
            }
            return;
        }
        short[] cv = values.toArray();
        for (int i = cv.length - 1; i >= 0; --i) {
            this.prepend(cv[i]);
        }
    }

    @Contract(mutates="this")
    public void insert(int var1, @Flow(targetIsContainer=true) short var2);

    @Contract(mutates="this")
    default public void insertAll(int index, @Flow(sourceIsContainer=true, targetIsContainer=true) short @NotNull [] values) {
        this.insertAll(index, ShortArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public void insertAll(int index, @NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) ShortTraversable values) {
        short[] valuesArray;
        Objects.requireNonNull(values);
        if (this.isEmpty() && index != 0) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        for (short e : valuesArray = values.toArray()) {
            this.insert(index++, e);
        }
    }

    @Contract(mutates="this")
    @Flow(sourceIsContainer=true)
    public short removeAt(int var1);

    default public void removeInRange(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int rangeLength = endIndex - beginIndex;
        if (rangeLength == 0) {
            return;
        }
        if (rangeLength == size) {
            this.clear();
            return;
        }
        for (int i = 0; i < rangeLength; ++i) {
            this.removeAt(beginIndex);
        }
    }

    @Contract(mutates="this")
    default public short removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(0);
    }

    @Contract(mutates="this")
    @Nullable
    default public Short removeFirstOrNull() {
        return this.isEmpty() ? null : Short.valueOf(this.removeAt(0));
    }

    @Contract(mutates="this")
    @NotNull
    default public ShortOption removeFirstOption() {
        return this.isEmpty() ? ShortOption.none() : ShortOption.some((short)this.removeAt(0));
    }

    @Contract(mutates="this")
    default public short removeLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(size - 1);
    }

    @Contract(mutates="this")
    @Nullable
    default public short removeLastOrNull() {
        int size = this.size();
        return size == 0 ? null : Short.valueOf(this.removeAt(size - 1));
    }

    @Contract(mutates="this")
    @NotNull
    default public ShortOption removeLastOption() {
        int size = this.size();
        return size == 0 ? ShortOption.none() : ShortOption.some((short)this.removeAt(size - 1));
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull ShortPredicate predicate) {
        MutableShortListIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            short value = it.nextShort();
            if (!predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull ShortPredicate predicate) {
        MutableShortListIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            short value = it.nextShort();
            if (predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Contract(mutates="this")
    public void clear();

    @Contract(mutates="this")
    default public void dropInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return;
        }
        MutableShortListIterator it = this.seqIterator();
        for (int i = 0; i < n && it.hasNext(); ++i) {
            it.nextShort();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void takeInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.clear();
            return;
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0 && n >= knownSize) {
            return;
        }
        MutableShortListIterator it = this.seqIterator(n);
        while (it.hasNext()) {
            it.nextShort();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull ShortPredicate predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull ShortPredicate predicate) {
        this.removeAll(predicate);
    }
}

