/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import kala.Conditions;
import kala.collection.base.primitive.ShortArrays;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.collection.factory.primitive.ShortCollectionFactory;
import kala.collection.mutable.primitive.MutablePrimitiveSeq;
import kala.collection.mutable.primitive.MutableShortArray;
import kala.collection.mutable.primitive.MutableShortCollection;
import kala.collection.mutable.primitive.MutableShortSeqIterator;
import kala.collection.primitive.ShortSeq;
import kala.collection.primitive.internal.ShortSeqIterators;
import kala.function.IndexedShortUnaryOperator;
import kala.function.ShortUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableShortSeq
extends MutablePrimitiveSeq<Short>,
ShortSeq,
MutableShortCollection {
    @NotNull
    public static ShortCollectionFactory<?, MutableShortSeq> factory() {
        return ShortCollectionFactory.narrow(MutableShortArray.factory());
    }

    @NotNull
    public static MutableShortSeq of() {
        return MutableShortArray.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableShortSeq of(short value1) {
        return MutableShortArray.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableShortSeq of(short value1, short value2) {
        return MutableShortArray.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableShortSeq of(short value1, short value2, short value3) {
        return MutableShortArray.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableShortSeq of(short value1, short value2, short value3, short value4) {
        return MutableShortArray.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableShortSeq of(short value1, short value2, short value3, short value4, short value5) {
        return MutableShortArray.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static MutableShortSeq of(short ... values) {
        return MutableShortArray.of(values);
    }

    @NotNull
    public static MutableShortSeq from(short @NotNull [] values) {
        return MutableShortArray.from(values);
    }

    @NotNull
    public static MutableShortSeq from(@NotNull ShortTraversable values) {
        return MutableShortArray.from(values);
    }

    @NotNull
    public static MutableShortSeq from(@NotNull ShortIterator it) {
        return MutableShortArray.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableShortSeq";
    }

    @NotNull
    default public ShortCollectionFactory<?, ? extends MutableShortSeq> iterableFactory() {
        return MutableShortSeq.factory();
    }

    @Override
    @NotNull
    default public MutableShortSeqIterator seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableShortSeqIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new ShortSeqIterators.DefaultMutableShortSeqIterator<MutableShortSeq>(this, index);
    }

    @Contract(mutates="this")
    public void set(int var1, short var2);

    default public void swap(int index1, int index2) {
        short old1 = this.get(index1);
        short old2 = this.get(index2);
        this.set(index1, old2);
        this.set(index2, old1);
    }

    @Contract(mutates="this")
    default public void replaceAll(@NotNull ShortUnaryOperator operator) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.set(i, operator.applyAsShort(this.get(i)));
        }
    }

    @Contract(mutates="this")
    default public void replaceAllIndexed(@NotNull IndexedShortUnaryOperator operator) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.set(i, operator.applyAsShort(i, this.get(i)));
        }
    }

    @Contract(mutates="this")
    default public void sort() {
        short[] values = this.toArray();
        Arrays.sort(values);
        for (int i = 0; i < values.length; ++i) {
            this.set(i, values[i]);
        }
    }

    @Contract(mutates="this")
    default public void reverse() {
        int size = this.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size / 2; ++i) {
            this.swap(i, size - i - 1);
        }
    }

    default public void shuffle() {
        this.shuffle(ThreadLocalRandom.current());
    }

    default public void shuffle(@NotNull Random random) {
        int ks = this.knownSize();
        if (ks == 0 || ks == 1) {
            return;
        }
        if (this.supportsFastRandomAccess() || ks > 0 && ks <= 5) {
            if (!1.$assertionsDisabled && ks <= 0) {
                throw new AssertionError();
            }
            for (int i2 = ks; i2 > 1; --i2) {
                this.swap(i2 - 1, random.nextInt(i2));
            }
        } else {
            short[] arr = this.toArray();
            ShortArrays.shuffle((short[])arr, (Random)random);
            this.replaceAllIndexed((i, v) -> arr[i]);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

