/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.Objects;
import kala.Conditions;
import kala.collection.SeqView;
import kala.collection.base.primitive.ByteTraversable;
import kala.collection.immutable.primitive.ImmutableByteSeq;
import kala.collection.primitive.ByteArraySeq;
import kala.collection.primitive.ByteCollectionView;
import kala.collection.primitive.ByteSeqLike;
import kala.collection.primitive.PrimitiveSeqView;
import kala.collection.primitive.internal.view.ByteSeqViews;
import kala.function.ByteFunction;
import kala.function.BytePredicate;
import kala.function.ByteUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface ByteSeqView
extends ByteSeqLike,
ByteCollectionView,
PrimitiveSeqView<Byte> {
    @NotNull
    public static ByteSeqView empty() {
        return ByteSeqViews.EMPTY;
    }

    @Override
    @NotNull
    default public String className() {
        return "ByteSeqView";
    }

    @Override
    @NotNull
    default public ByteSeqView view() {
        return this;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView slice(int beginIndex, int endIndex) {
        int ks = this.knownSize();
        if (ks == 0) {
            if (beginIndex != 0) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            if (endIndex != 0) {
                throw new IndexOutOfBoundsException("endIndex: " + endIndex);
            }
            return ByteSeqView.empty();
        }
        if (ks > 0) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)ks);
        } else {
            if (beginIndex < 0) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
            }
            if (beginIndex > endIndex) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > endIndex(" + endIndex + ")");
            }
        }
        return new ByteSeqViews.Slice(this, beginIndex, endIndex);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return ByteSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return ByteSeqView.empty();
        }
        return new ByteSeqViews.Drop(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView dropLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return ByteSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return ByteSeqView.empty();
        }
        return new ByteSeqViews.DropLast(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView dropWhile(@NotNull BytePredicate predicate) {
        Objects.requireNonNull(predicate);
        return new ByteSeqViews.DropWhile(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return ByteSeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return ByteSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new ByteSeqViews.Take(this, n);
    }

    @Override
    @NotNull
    default public ByteSeqView takeLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return ByteSeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return ByteSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new ByteSeqViews.TakeLast(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView takeWhile(@NotNull BytePredicate predicate) {
        Objects.requireNonNull(predicate);
        return new ByteSeqViews.TakeWhile(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView updated(int index, byte newValue) {
        int ks = this.knownSize();
        if (ks < 0) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
        } else {
            Conditions.checkElementIndex((int)index, (int)ks);
        }
        return new ByteSeqViews.Updated(this, index, newValue);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView concat(@NotNull ByteSeqLike other) {
        Objects.requireNonNull(other);
        return new ByteSeqViews.Concat(this, other.view());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView prepended(byte value) {
        return new ByteSeqViews.Prepended(this, value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView prependedAll(byte @NotNull [] values) {
        Objects.requireNonNull(values);
        return new ByteSeqViews.Concat(ByteArraySeq.wrap(values), this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView prependedAll(@NotNull ByteTraversable values) {
        Objects.requireNonNull(values);
        return new ByteSeqViews.Concat(values instanceof ByteSeqLike ? (ByteSeqLike)values : ImmutableByteSeq.from(values), this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView appended(byte value) {
        return new ByteSeqViews.Appended(this, value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView appendedAll(byte @NotNull [] values) {
        Objects.requireNonNull(values);
        return new ByteSeqViews.Concat(this, ByteArraySeq.wrap(values));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView appendedAll(@NotNull ByteTraversable values) {
        Objects.requireNonNull(values);
        return new ByteSeqViews.Concat(this, values instanceof ByteSeqLike ? (ByteSeqLike)values : ImmutableByteSeq.from(values));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView sorted() {
        return new ByteSeqViews.Sorted(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView reversed() {
        return new ByteSeqViews.Reversed(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView filter(@NotNull BytePredicate predicate) {
        Objects.requireNonNull(predicate);
        return new ByteSeqViews.Filter(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView filterNot(@NotNull BytePredicate predicate) {
        Objects.requireNonNull(predicate);
        return new ByteSeqViews.FilterNot(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView map(@NotNull ByteUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return new ByteSeqViews.Mapped(this, mapper);
    }

    @Contract(pure=true)
    @NotNull
    default public <U> SeqView<U> mapToObj(@NotNull ByteFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return new ByteSeqViews.MapToObj<U>(this, mapper);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ByteSeqView flatMap(@NotNull ByteFunction<? extends ByteTraversable> mapper) {
        Objects.requireNonNull(mapper);
        return new ByteSeqViews.FlatMapped(this, mapper);
    }
}

