/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import kala.collection.AnySet;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.collection.factory.primitive.ByteCollectionFactory;
import kala.collection.immutable.primitive.ImmutableByteSet;
import kala.collection.primitive.ByteCollection;
import kala.collection.primitive.ByteSetLike;
import kala.collection.primitive.ByteSetView;
import kala.collection.primitive.PrimitiveSet;
import kala.collection.primitive.internal.view.ByteSetViews;
import kala.function.BytePredicate;
import org.jetbrains.annotations.NotNull;

public interface ByteSet
extends PrimitiveSet<Byte>,
ByteCollection,
ByteSetLike {
    public static ByteCollectionFactory<?, ByteSet> factory() {
        return ByteCollectionFactory.narrow(ImmutableByteSet.factory());
    }

    @NotNull
    public static ByteSet empty() {
        return ImmutableByteSet.empty();
    }

    @NotNull
    public static ByteSet of() {
        return ImmutableByteSet.of();
    }

    @NotNull
    public static ByteSet of(byte value1) {
        return ImmutableByteSet.of(value1);
    }

    @NotNull
    public static ByteSet of(byte value1, byte value2) {
        return ImmutableByteSet.of(value1, value2);
    }

    @NotNull
    public static ByteSet of(byte value1, byte value2, byte value3) {
        return ImmutableByteSet.of(value1, value2, value3);
    }

    @NotNull
    public static ByteSet of(byte value1, byte value2, byte value3, byte value4) {
        return ImmutableByteSet.of(value1, value2, value3, value4);
    }

    @NotNull
    public static ByteSet of(byte value1, byte value2, byte value3, byte value4, byte value5) {
        return ImmutableByteSet.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static ByteSet of(byte ... values) {
        return ImmutableByteSet.of(values);
    }

    @NotNull
    public static ByteSet from(byte @NotNull [] values) {
        return ImmutableByteSet.from(values);
    }

    @NotNull
    public static ByteSet from(@NotNull ByteTraversable values) {
        return ImmutableByteSet.from(values);
    }

    @NotNull
    public static ByteSet from(@NotNull ByteIterator it) {
        return ImmutableByteSet.from(it);
    }

    public static int hashCode(@NotNull ByteSet set) {
        int h = 1045751549;
        ByteIterator it = set.iterator();
        while (it.hasNext()) {
            h += Byte.hashCode(it.nextByte());
        }
        return h;
    }

    public static boolean equals(@NotNull ByteSet set1, @NotNull AnySet<?> set2) {
        if (set1 == set2) {
            return true;
        }
        if (!set1.canEqual(set2) || !set2.canEqual((Object)set1)) {
            return false;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        if (set2 instanceof ByteSet) {
            return set1.containsAll((ByteSet)set2);
        }
        for (Object v : set2.asGeneric()) {
            if (v instanceof Byte && set1.contains((Byte)v)) continue;
            return false;
        }
        return true;
    }

    default public boolean contains(byte value) {
        return this.iterator().contains(value);
    }

    @Override
    @NotNull
    default public String className() {
        return "ByteSet";
    }

    @NotNull
    default public ByteCollectionFactory<?, ? extends ByteSet> iterableFactory() {
        return ByteSet.factory();
    }

    @Override
    @NotNull
    default public ByteSetView view() {
        return new ByteSetViews.Of<ByteSet>(this);
    }

    @Override
    @NotNull
    default public ImmutableByteSet filter(@NotNull BytePredicate predicate) {
        return ImmutableByteSet.from(this.view().filter(predicate));
    }

    @Override
    @NotNull
    default public ImmutableByteSet filterNot(@NotNull BytePredicate predicate) {
        return ImmutableByteSet.from(this.view().filterNot(predicate));
    }
}

