/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import kala.Conditions;
import kala.collection.SeqLike;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.mutable.primitive.MutableCharArrayList;
import kala.collection.primitive.CharCollectionLike;
import kala.collection.primitive.CharSeqIterator;
import kala.collection.primitive.CharSeqView;
import kala.collection.primitive.PrimitiveSeqLike;
import kala.collection.primitive.internal.CharSeqIterators;
import kala.control.primitive.CharOption;
import kala.function.CharFunction;
import kala.function.CharPredicate;
import kala.function.CharUnaryOperator;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface CharSeqLike
extends PrimitiveSeqLike<Character>,
CharCollectionLike {
    @Override
    @NotNull
    default public String className() {
        return "CharSeqLike";
    }

    @Override
    @NotNull
    public CharSeqView view();

    @NotNull
    default public CharIterator iterator(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0) {
            if (beginIndex > knownSize) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > size(" + knownSize + ")");
            }
            if (beginIndex == knownSize) {
                return CharIterator.empty();
            }
        }
        CharIterator it = this.iterator();
        for (int i = 0; i < beginIndex; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            it.nextChar();
        }
        return it;
    }

    @NotNull
    default public CharSeqIterator seqIterator() {
        return this.seqIterator(0);
    }

    @NotNull
    default public CharSeqIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new CharSeqIterators.DefaultCharSeqIterator<CharSeqLike>(this, index);
    }

    @Contract(pure=true)
    default public boolean isDefinedAt(int index) {
        return index >= 0 && this.sizeGreaterThan(index);
    }

    default public char elementAt(int index) {
        return this.get(index);
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true)
    default public char get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.iterator(index).nextChar();
    }

    @Contract(pure=true)
    @Nullable
    default public Character getOrNull(int index) {
        return this.isDefinedAt(index) ? Character.valueOf(this.get(index)) : null;
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true, targetIsContainer=true)
    @NotNull
    default public CharOption getOption(int index) {
        return this.isDefinedAt(index) ? CharOption.some((char)this.get(index)) : CharOption.none();
    }

    @NotNull
    default public CharIterator reverseIterator() {
        CharIterator it = this.iterator();
        if (!it.hasNext()) {
            return it;
        }
        MutableCharArrayList builder = new MutableCharArrayList();
        while (it.hasNext()) {
            builder.append(it.nextChar());
        }
        return builder.reverseIterator();
    }

    @NotNull
    default public CharOption find(@NotNull CharPredicate predicate) {
        return this.findFirst(predicate);
    }

    @NotNull
    default public CharOption findFirst(@NotNull CharPredicate predicate) {
        return this.iterator().find(predicate);
    }

    @NotNull
    default public CharOption findLast(@NotNull CharPredicate predicate) {
        return this.reverseIterator().find(predicate);
    }

    default public char first() {
        return this.iterator().nextChar();
    }

    @Nullable
    default public Character firstOrNull() {
        return this.isNotEmpty() ? Character.valueOf(this.first()) : null;
    }

    @NotNull
    default public CharOption firstOption() {
        return this.isNotEmpty() ? CharOption.some((char)this.first()) : CharOption.none();
    }

    default public char last() {
        return this.reverseIterator().nextChar();
    }

    @Nullable
    default public Character lastOrNull() {
        return this.isNotEmpty() ? Character.valueOf(this.last()) : null;
    }

    @NotNull
    default public CharOption lastOption() {
        return this.isNotEmpty() ? CharOption.some((char)this.last()) : CharOption.none();
    }

    default public char first(@NotNull CharPredicate predicate) {
        return this.findFirst(predicate).get();
    }

    @Nullable
    default public Character firstOrNull(@NotNull CharPredicate predicate) {
        return this.findFirst(predicate).getOrNull();
    }

    @NotNull
    default public CharOption firstOption(@NotNull CharPredicate predicate) {
        return this.findFirst(predicate);
    }

    default public char last(@NotNull CharPredicate predicate) {
        return this.findLast(predicate).get();
    }

    @Nullable
    default public Character lastOrNull(@NotNull CharPredicate predicate) {
        return this.findLast(predicate).getOrNull();
    }

    @NotNull
    default public CharOption lastOption(@NotNull CharPredicate predicate) {
        return this.findLast(predicate);
    }

    @Contract(pure=true)
    default public int indexOf(char value) {
        int idx = 0;
        CharIterator it = this.iterator();
        while (it.hasNext()) {
            if (value == it.nextChar()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexOf(char value, int from) {
        int idx = 0;
        CharIterator it = this.iterator();
        while (it.hasNext()) {
            if (idx >= from && value == it.nextChar()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull CharPredicate predicate) {
        int idx = 0;
        CharIterator it = this.iterator();
        while (it.hasNext()) {
            if (predicate.test(it.nextChar())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull CharPredicate predicate, int from) {
        int idx = 0;
        CharIterator it = this.iterator();
        while (it.hasNext()) {
            if (idx >= from && predicate.test(it.nextChar())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(char value) {
        int idx = this.size() - 1;
        CharIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (value == it.nextChar()) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(char value, int end) {
        int idx = this.size() - 1;
        CharIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && value == it.nextChar()) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull CharPredicate predicate) {
        int idx = this.size() - 1;
        CharIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (predicate.test(it.nextChar())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull CharPredicate predicate, int end) {
        int idx = this.size() - 1;
        CharIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && predicate.test(it.nextChar())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    @NotNull
    public CharSeqLike slice(int var1, int var2);

    @Contract(pure=true)
    @NotNull
    public CharSeqLike drop(int var1);

    @Contract(pure=true)
    @NotNull
    public CharSeqLike dropLast(int var1);

    @Contract(pure=true)
    @NotNull
    public CharSeqLike dropWhile(@NotNull CharPredicate var1);

    @Contract(pure=true)
    @NotNull
    public CharSeqLike take(int var1);

    @NotNull
    public CharSeqLike takeLast(int var1);

    @Contract(pure=true)
    @NotNull
    public CharSeqLike takeWhile(@NotNull CharPredicate var1);

    @Contract(pure=true)
    @NotNull
    public CharSeqLike updated(int var1, char var2);

    @Contract(pure=true)
    @NotNull
    public CharSeqLike concat(@NotNull CharSeqLike var1);

    @Contract(pure=true)
    @NotNull
    public CharSeqLike prepended(char var1);

    @Contract(pure=true)
    @NotNull
    public CharSeqLike prependedAll(char @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public CharSeqLike prependedAll(@NotNull CharTraversable var1);

    @Contract(pure=true)
    @NotNull
    public CharSeqLike appended(char var1);

    @Contract(pure=true)
    @NotNull
    public CharSeqLike appendedAll(@NotNull CharTraversable var1);

    @Contract(pure=true)
    @NotNull
    public CharSeqLike appendedAll(char @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public CharSeqLike sorted();

    @Contract(pure=true)
    @NotNull
    public CharSeqLike reversed();

    @Override
    @Contract(pure=true)
    @NotNull
    public CharSeqLike filter(@NotNull CharPredicate var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public CharSeqLike filterNot(@NotNull CharPredicate var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public CharSeqLike map(@NotNull CharUnaryOperator var1);

    @Contract(pure=true)
    @NotNull
    public <U> SeqLike<U> mapToObj(@NotNull CharFunction<? extends U> var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public CharSeqLike flatMap(@NotNull CharFunction<? extends CharTraversable> var1);
}

