/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import kala.Conditions;
import kala.collection.base.primitive.AbstractIntIterator;
import kala.collection.base.primitive.IntIterator;
import kala.collection.primitive.IntSeqLike;
import kala.control.primitive.IntOption;
import org.jetbrains.annotations.NotNull;

public interface IndexedIntSeqLike
extends IntSeqLike,
RandomAccess {
    @NotNull
    default public IntIterator iterator() {
        return this.iterator(0);
    }

    @Override
    @NotNull
    default public IntIterator iterator(int beginIndex) {
        final int size = this.size();
        if (size == 0) {
            return IntIterator.empty();
        }
        final class Itr
        extends AbstractIntIterator {
            private int idx;

            Itr(int beginIndex) {
                this.idx = beginIndex;
            }

            public boolean hasNext() {
                return this.idx < size;
            }

            public int nextInt() {
                if (this.idx >= size) {
                    throw new NoSuchElementException();
                }
                return IndexedIntSeqLike.this.get(this.idx++);
            }
        }
        return new Itr(beginIndex);
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public int knownSize() {
        return this.size();
    }

    default public boolean supportsFastRandomAccess() {
        return true;
    }

    @Override
    default public boolean isDefinedAt(int index) {
        return index >= 0 && index < this.size();
    }

    @Override
    public int get(int var1);

    @Override
    @NotNull
    default public IntIterator reverseIterator() {
        if (this.isEmpty()) {
            return IntIterator.empty();
        }
        return new AbstractIntIterator(){
            private int idx = this.size() - 1;

            public boolean hasNext() {
                return this.idx >= 0;
            }

            public int nextInt() {
                if (this.idx < 0) {
                    throw new NoSuchElementException();
                }
                return IndexedIntSeqLike.this.get(this.idx--);
            }
        };
    }

    default public int binarySearch(int value) {
        return this.binarySearch(0, this.size(), value);
    }

    default public int binarySearch(int beginIndex, int endIndex, int value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
        int low = beginIndex;
        int high = endIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this.get(mid);
            int cmp = Integer.compare(midVal, value);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    @NotNull
    default public IntOption findFirst(@NotNull IntPredicate predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int e = this.get(i);
            if (!predicate.test(e)) continue;
            return IntOption.some((int)e);
        }
        return IntOption.none();
    }

    @Override
    @NotNull
    default public IntOption findLast(@NotNull IntPredicate predicate) {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            int e = this.get(i);
            if (!predicate.test(e)) continue;
            return IntOption.some((int)e);
        }
        return IntOption.none();
    }

    @Override
    default public int first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    @Override
    default public int last() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(size - 1);
    }

    default public void forEach(@NotNull IntConsumer action) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            action.accept(this.get(i));
        }
    }
}

