/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import kala.Conditions;
import kala.collection.base.primitive.AbstractLongIterator;
import kala.collection.base.primitive.LongIterator;
import kala.collection.primitive.LongSeqLike;
import kala.control.primitive.LongOption;
import org.jetbrains.annotations.NotNull;

public interface IndexedLongSeqLike
extends LongSeqLike,
RandomAccess {
    @NotNull
    default public LongIterator iterator() {
        return this.iterator(0);
    }

    @Override
    @NotNull
    default public LongIterator iterator(int beginIndex) {
        final int size = this.size();
        if (size == 0) {
            return LongIterator.empty();
        }
        final class Itr
        extends AbstractLongIterator {
            private int idx;

            Itr(int beginIndex) {
                this.idx = beginIndex;
            }

            public boolean hasNext() {
                return this.idx < size;
            }

            public long nextLong() {
                if (this.idx >= size) {
                    throw new NoSuchElementException();
                }
                return IndexedLongSeqLike.this.get(this.idx++);
            }
        }
        return new Itr(beginIndex);
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public int knownSize() {
        return this.size();
    }

    default public boolean supportsFastRandomAccess() {
        return true;
    }

    @Override
    default public boolean isDefinedAt(int index) {
        return index >= 0 && index < this.size();
    }

    @Override
    public long get(int var1);

    @Override
    @NotNull
    default public LongIterator reverseIterator() {
        if (this.isEmpty()) {
            return LongIterator.empty();
        }
        return new AbstractLongIterator(){
            private int idx = this.size() - 1;

            public boolean hasNext() {
                return this.idx >= 0;
            }

            public long nextLong() {
                if (this.idx < 0) {
                    throw new NoSuchElementException();
                }
                return IndexedLongSeqLike.this.get(this.idx--);
            }
        };
    }

    default public int binarySearch(long value) {
        return this.binarySearch(0, this.size(), value);
    }

    default public int binarySearch(int beginIndex, int endIndex, long value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
        int low = beginIndex;
        int high = endIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = this.get(mid);
            int cmp = Long.compare(midVal, value);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    @NotNull
    default public LongOption findFirst(@NotNull LongPredicate predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            long e = this.get(i);
            if (!predicate.test(e)) continue;
            return LongOption.some((long)e);
        }
        return LongOption.none();
    }

    @Override
    @NotNull
    default public LongOption findLast(@NotNull LongPredicate predicate) {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            long e = this.get(i);
            if (!predicate.test(e)) continue;
            return LongOption.some((long)e);
        }
        return LongOption.none();
    }

    @Override
    default public long first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    @Override
    default public long last() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(size - 1);
    }

    default public void forEach(@NotNull LongConsumer action) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            action.accept(this.get(i));
        }
    }
}

